/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.commands;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.plugin.JptJpaEclipseLinkUiPlugin;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EclipseLinkUpgradeXmlResourceToMappingFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            this.upgradeToEclipseLinkMappingFile(selectedObject);
            ++n2;
        }
        return null;
    }

    protected void upgradeToEclipseLinkMappingFile(Object selectedObject) {
        EclipseLinkUpgradeXmlResourceToMappingFileHandler.upgradeToEclipseLinkMappingFile(this.adaptSelection(selectedObject));
    }

    protected JptXmlResource adaptSelection(Object selectedObject) {
        return (JptXmlResource)PlatformTools.getAdapter((Object)selectedObject, JptXmlResource.class);
    }

    protected static void upgradeToEclipseLinkMappingFile(JptXmlResource xmlResource) {
        IProject project = xmlResource.getFile().getProject();
        JpaProject jpaProject = EclipseLinkUpgradeXmlResourceToMappingFileHandler.getJpaProject(project);
        if (jpaProject == null) {
            throw new IllegalStateException("Missing JPA project: " + project.getName());
        }
        String newVersion = jpaProject.getJpaPlatform().getMostRecentSupportedResourceType(XmlEntityMappings.CONTENT_TYPE).getVersion();
        String fileLocation = xmlResource.getFile().getRawLocation().toOSString();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(fileLocation));
            document.setXmlStandalone(true);
            NodeList nodes = document.getElementsByTagName("entity-mappings");
            if (nodes.getLength() > 0) {
                Node node = nodes.item(0);
                NamedNodeMap attributes = node.getAttributes();
                attributes.getNamedItem("version").setTextContent(newVersion);
                attributes.getNamedItem("xmlns").setTextContent(EclipseLinkUpgradeXmlResourceToMappingFileHandler.getNamespace());
                attributes.getNamedItem("xsi:schemaLocation").setTextContent(EclipseLinkUpgradeXmlResourceToMappingFileHandler.buildSchemaLocationString(EclipseLinkUpgradeXmlResourceToMappingFileHandler.getNamespace(), EclipseLinkUpgradeXmlResourceToMappingFileHandler.getSchemaLocationForVersion(newVersion)));
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(new File(fileLocation)));
            xmlResource.getFile().refreshLocal(0, null);
        }
        catch (ParserConfigurationException pce) {
            JptJpaEclipseLinkUiPlugin.instance().logError(pce);
        }
        catch (SAXException sxe) {
            JptJpaEclipseLinkUiPlugin.instance().logError(sxe);
        }
        catch (IOException ioe) {
            JptJpaEclipseLinkUiPlugin.instance().logError(ioe);
        }
        catch (TransformerConfigurationException tce) {
            JptJpaEclipseLinkUiPlugin.instance().logError(tce);
        }
        catch (TransformerException te) {
            JptJpaEclipseLinkUiPlugin.instance().logError(te);
        }
        catch (CoreException ce) {
            JptJpaEclipseLinkUiPlugin.instance().logError(ce);
        }
    }

    private static JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    protected static String buildSchemaLocationString(String namespace, String schemaLocation) {
        return String.valueOf(namespace) + ' ' + schemaLocation;
    }

    protected static String getNamespace() {
        return "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
    }

    protected static String getSchemaLocationForVersion(String schemaVersion) {
        String schemaLocation = (String)XmlEntityMappings.SCHEMA_LOCATIONS.get(schemaVersion);
        if (schemaLocation == null) {
            JptJpaEclipseLinkUiPlugin.instance().logError(new Throwable("No schema location defined for version: " + schemaVersion));
        }
        return schemaLocation;
    }
}

