package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.portpos.PortPos;
import org.eclipse.gef.dot.internal.language.portpos.PortposPackage;
import org.eclipse.gef.dot.internal.language.services.DotPortPosGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

@SuppressWarnings("all")
public class DotPortPosSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotPortPosGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == PortposPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case PortposPackage.PORT_POS:
				if(context == grammarAccess.getPortPosRule()) {
					sequence_PortPos(context, (PortPos) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (port=Port compassPoint=COMPASS_POINT_POS?)
	 */
	protected void sequence_PortPos(EObject context, PortPos semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
