/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.core.util.Logs;

public class ReportProcessorSafeWrapper implements IReportProcessor {

    private IReportProcessor reportProcessor;

    public ReportProcessorSafeWrapper(IReportProcessor reportProcessor) {
        this.reportProcessor = reportProcessor;
    }

    @Override
    public boolean canContribute(IStatus status, IEclipseContext context) {
        try {
            return reportProcessor.canContribute(status, context);
        } catch (Exception e) {
            Logs.log(LogMessages.WARN_REPORT_PROCESSOR_FAILED, e, reportProcessor);
            return false;
        }
    }

    @Override
    public boolean wantsToContribute(IStatus status, IEclipseContext context) {
        try {
            return reportProcessor.wantsToContribute(status, context);
        } catch (Exception e) {
            Logs.log(LogMessages.WARN_REPORT_PROCESSOR_FAILED, e, reportProcessor);
            return false;
        }
    }

    @Override
    public void process(IReport report, IStatus status, IEclipseContext context) {
        try {
            reportProcessor.process(report, status, context);
        } catch (Exception e) {
            Logs.log(LogMessages.WARN_REPORT_PROCESSOR_FAILED, e, reportProcessor);
        }
    }

    public IReportProcessor getWrapped() {
        return reportProcessor;
    }
}
