/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.epp.logging.aeri.core.IBundle;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IStatus;
import org.eclipse.epp.logging.aeri.core.Severity;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Report</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getAnonymousId <em>Anonymous Id</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getEmail <em>Email</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getComment <em>Comment</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getEclipseBuildId <em>Eclipse Build Id</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getEclipseProduct <em>Eclipse Product</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getJavaRuntimeVersion <em>Java Runtime Version</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getOsgiWs <em>Osgi Ws</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getOsgiOs <em>Osgi Os</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getOsgiOsVersion <em>Osgi Os Version</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getOsgiArch <em>Osgi Arch</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getPresentBundles <em>Present Bundles</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getStatus <em>Status</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getSeverity <em>Severity</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ReportImpl#getAuxiliaryInformation <em>Auxiliary Information</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ReportImpl extends MinimalEObjectImpl.Container implements IReport {
	/**
	 * The default value of the '{@link #getAnonymousId() <em>Anonymous Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnonymousId()
	 * @generated
	 * @ordered
	 */
	protected static final String ANONYMOUS_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAnonymousId() <em>Anonymous Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnonymousId()
	 * @generated
	 * @ordered
	 */
	protected String anonymousId = ANONYMOUS_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getEmail() <em>Email</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEmail()
	 * @generated
	 * @ordered
	 */
	protected static final String EMAIL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEmail() <em>Email</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEmail()
	 * @generated
	 * @ordered
	 */
	protected String email = EMAIL_EDEFAULT;

	/**
	 * The default value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected static final String COMMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected String comment = COMMENT_EDEFAULT;

	/**
	 * The default value of the '{@link #getEclipseBuildId() <em>Eclipse Build Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEclipseBuildId()
	 * @generated
	 * @ordered
	 */
	protected static final String ECLIPSE_BUILD_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEclipseBuildId() <em>Eclipse Build Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEclipseBuildId()
	 * @generated
	 * @ordered
	 */
	protected String eclipseBuildId = ECLIPSE_BUILD_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getEclipseProduct() <em>Eclipse Product</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEclipseProduct()
	 * @generated
	 * @ordered
	 */
	protected static final String ECLIPSE_PRODUCT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEclipseProduct() <em>Eclipse Product</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEclipseProduct()
	 * @generated
	 * @ordered
	 */
	protected String eclipseProduct = ECLIPSE_PRODUCT_EDEFAULT;

	/**
	 * The default value of the '{@link #getJavaRuntimeVersion() <em>Java Runtime Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJavaRuntimeVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String JAVA_RUNTIME_VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getJavaRuntimeVersion() <em>Java Runtime Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJavaRuntimeVersion()
	 * @generated
	 * @ordered
	 */
	protected String javaRuntimeVersion = JAVA_RUNTIME_VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #getOsgiWs() <em>Osgi Ws</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsgiWs()
	 * @generated
	 * @ordered
	 */
	protected static final String OSGI_WS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOsgiWs() <em>Osgi Ws</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsgiWs()
	 * @generated
	 * @ordered
	 */
	protected String osgiWs = OSGI_WS_EDEFAULT;

	/**
	 * The default value of the '{@link #getOsgiOs() <em>Osgi Os</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsgiOs()
	 * @generated
	 * @ordered
	 */
	protected static final String OSGI_OS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOsgiOs() <em>Osgi Os</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsgiOs()
	 * @generated
	 * @ordered
	 */
	protected String osgiOs = OSGI_OS_EDEFAULT;

	/**
	 * The default value of the '{@link #getOsgiOsVersion() <em>Osgi Os Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsgiOsVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String OSGI_OS_VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOsgiOsVersion() <em>Osgi Os Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsgiOsVersion()
	 * @generated
	 * @ordered
	 */
	protected String osgiOsVersion = OSGI_OS_VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #getOsgiArch() <em>Osgi Arch</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsgiArch()
	 * @generated
	 * @ordered
	 */
	protected static final String OSGI_ARCH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOsgiArch() <em>Osgi Arch</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsgiArch()
	 * @generated
	 * @ordered
	 */
	protected String osgiArch = OSGI_ARCH_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPresentBundles() <em>Present Bundles</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPresentBundles()
	 * @generated
	 * @ordered
	 */
	protected EList<IBundle> presentBundles;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected IStatus status;

	/**
	 * The default value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeverity()
	 * @generated
	 * @ordered
	 */
	protected static final Severity SEVERITY_EDEFAULT = Severity.UNKNOWN;

	/**
	 * The cached value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeverity()
	 * @generated
	 * @ordered
	 */
	protected Severity severity = SEVERITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAuxiliaryInformation() <em>Auxiliary Information</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAuxiliaryInformation()
	 * @generated
	 * @ordered
	 */
	protected EMap<String, String> auxiliaryInformation;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReportImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IModelPackage.Literals.REPORT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAnonymousId() {
		return anonymousId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnonymousId(String newAnonymousId) {
		String oldAnonymousId = anonymousId;
		anonymousId = newAnonymousId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__ANONYMOUS_ID, oldAnonymousId, anonymousId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEmail(String newEmail) {
		String oldEmail = email;
		email = newEmail;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__EMAIL, oldEmail, email));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setComment(String newComment) {
		String oldComment = comment;
		comment = newComment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__COMMENT, oldComment, comment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getEclipseBuildId() {
		return eclipseBuildId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEclipseBuildId(String newEclipseBuildId) {
		String oldEclipseBuildId = eclipseBuildId;
		eclipseBuildId = newEclipseBuildId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__ECLIPSE_BUILD_ID, oldEclipseBuildId, eclipseBuildId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getEclipseProduct() {
		return eclipseProduct;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEclipseProduct(String newEclipseProduct) {
		String oldEclipseProduct = eclipseProduct;
		eclipseProduct = newEclipseProduct;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__ECLIPSE_PRODUCT, oldEclipseProduct, eclipseProduct));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getJavaRuntimeVersion() {
		return javaRuntimeVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setJavaRuntimeVersion(String newJavaRuntimeVersion) {
		String oldJavaRuntimeVersion = javaRuntimeVersion;
		javaRuntimeVersion = newJavaRuntimeVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__JAVA_RUNTIME_VERSION, oldJavaRuntimeVersion, javaRuntimeVersion));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOsgiWs() {
		return osgiWs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOsgiWs(String newOsgiWs) {
		String oldOsgiWs = osgiWs;
		osgiWs = newOsgiWs;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__OSGI_WS, oldOsgiWs, osgiWs));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOsgiOs() {
		return osgiOs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOsgiOs(String newOsgiOs) {
		String oldOsgiOs = osgiOs;
		osgiOs = newOsgiOs;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__OSGI_OS, oldOsgiOs, osgiOs));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOsgiOsVersion() {
		return osgiOsVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOsgiOsVersion(String newOsgiOsVersion) {
		String oldOsgiOsVersion = osgiOsVersion;
		osgiOsVersion = newOsgiOsVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__OSGI_OS_VERSION, oldOsgiOsVersion, osgiOsVersion));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOsgiArch() {
		return osgiArch;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOsgiArch(String newOsgiArch) {
		String oldOsgiArch = osgiArch;
		osgiArch = newOsgiArch;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__OSGI_ARCH, oldOsgiArch, osgiArch));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IBundle> getPresentBundles() {
		if (presentBundles == null) {
			presentBundles = new EObjectContainmentEList<IBundle>(IBundle.class, this, IModelPackage.REPORT__PRESENT_BUNDLES);
		}
		return presentBundles;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IStatus getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStatus(IStatus newStatus, NotificationChain msgs) {
		IStatus oldStatus = status;
		status = newStatus;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__STATUS, oldStatus, newStatus);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatus(IStatus newStatus) {
		if (newStatus != status) {
			NotificationChain msgs = null;
			if (status != null)
				msgs = ((InternalEObject)status).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - IModelPackage.REPORT__STATUS, null, msgs);
			if (newStatus != null)
				msgs = ((InternalEObject)newStatus).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - IModelPackage.REPORT__STATUS, null, msgs);
			msgs = basicSetStatus(newStatus, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__STATUS, newStatus, newStatus));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Severity getSeverity() {
		return severity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSeverity(Severity newSeverity) {
		Severity oldSeverity = severity;
		severity = newSeverity == null ? SEVERITY_EDEFAULT : newSeverity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.REPORT__SEVERITY, oldSeverity, severity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EMap<String, String> getAuxiliaryInformation() {
		if (auxiliaryInformation == null) {
			auxiliaryInformation = new EcoreEMap<String,String>(IModelPackage.Literals.STRING_TO_STRING_MAP, StringToStringMapImpl.class, this, IModelPackage.REPORT__AUXILIARY_INFORMATION);
		}
		return auxiliaryInformation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IModelPackage.REPORT__PRESENT_BUNDLES:
				return ((InternalEList<?>)getPresentBundles()).basicRemove(otherEnd, msgs);
			case IModelPackage.REPORT__STATUS:
				return basicSetStatus(null, msgs);
			case IModelPackage.REPORT__AUXILIARY_INFORMATION:
				return ((InternalEList<?>)getAuxiliaryInformation()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IModelPackage.REPORT__ANONYMOUS_ID:
				return getAnonymousId();
			case IModelPackage.REPORT__NAME:
				return getName();
			case IModelPackage.REPORT__EMAIL:
				return getEmail();
			case IModelPackage.REPORT__COMMENT:
				return getComment();
			case IModelPackage.REPORT__ECLIPSE_BUILD_ID:
				return getEclipseBuildId();
			case IModelPackage.REPORT__ECLIPSE_PRODUCT:
				return getEclipseProduct();
			case IModelPackage.REPORT__JAVA_RUNTIME_VERSION:
				return getJavaRuntimeVersion();
			case IModelPackage.REPORT__OSGI_WS:
				return getOsgiWs();
			case IModelPackage.REPORT__OSGI_OS:
				return getOsgiOs();
			case IModelPackage.REPORT__OSGI_OS_VERSION:
				return getOsgiOsVersion();
			case IModelPackage.REPORT__OSGI_ARCH:
				return getOsgiArch();
			case IModelPackage.REPORT__PRESENT_BUNDLES:
				return getPresentBundles();
			case IModelPackage.REPORT__STATUS:
				return getStatus();
			case IModelPackage.REPORT__SEVERITY:
				return getSeverity();
			case IModelPackage.REPORT__AUXILIARY_INFORMATION:
				if (coreType) return getAuxiliaryInformation();
				else return getAuxiliaryInformation().map();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IModelPackage.REPORT__ANONYMOUS_ID:
				setAnonymousId((String)newValue);
				return;
			case IModelPackage.REPORT__NAME:
				setName((String)newValue);
				return;
			case IModelPackage.REPORT__EMAIL:
				setEmail((String)newValue);
				return;
			case IModelPackage.REPORT__COMMENT:
				setComment((String)newValue);
				return;
			case IModelPackage.REPORT__ECLIPSE_BUILD_ID:
				setEclipseBuildId((String)newValue);
				return;
			case IModelPackage.REPORT__ECLIPSE_PRODUCT:
				setEclipseProduct((String)newValue);
				return;
			case IModelPackage.REPORT__JAVA_RUNTIME_VERSION:
				setJavaRuntimeVersion((String)newValue);
				return;
			case IModelPackage.REPORT__OSGI_WS:
				setOsgiWs((String)newValue);
				return;
			case IModelPackage.REPORT__OSGI_OS:
				setOsgiOs((String)newValue);
				return;
			case IModelPackage.REPORT__OSGI_OS_VERSION:
				setOsgiOsVersion((String)newValue);
				return;
			case IModelPackage.REPORT__OSGI_ARCH:
				setOsgiArch((String)newValue);
				return;
			case IModelPackage.REPORT__PRESENT_BUNDLES:
				getPresentBundles().clear();
				getPresentBundles().addAll((Collection<? extends IBundle>)newValue);
				return;
			case IModelPackage.REPORT__STATUS:
				setStatus((IStatus)newValue);
				return;
			case IModelPackage.REPORT__SEVERITY:
				setSeverity((Severity)newValue);
				return;
			case IModelPackage.REPORT__AUXILIARY_INFORMATION:
				((EStructuralFeature.Setting)getAuxiliaryInformation()).set(newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IModelPackage.REPORT__ANONYMOUS_ID:
				setAnonymousId(ANONYMOUS_ID_EDEFAULT);
				return;
			case IModelPackage.REPORT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case IModelPackage.REPORT__EMAIL:
				setEmail(EMAIL_EDEFAULT);
				return;
			case IModelPackage.REPORT__COMMENT:
				setComment(COMMENT_EDEFAULT);
				return;
			case IModelPackage.REPORT__ECLIPSE_BUILD_ID:
				setEclipseBuildId(ECLIPSE_BUILD_ID_EDEFAULT);
				return;
			case IModelPackage.REPORT__ECLIPSE_PRODUCT:
				setEclipseProduct(ECLIPSE_PRODUCT_EDEFAULT);
				return;
			case IModelPackage.REPORT__JAVA_RUNTIME_VERSION:
				setJavaRuntimeVersion(JAVA_RUNTIME_VERSION_EDEFAULT);
				return;
			case IModelPackage.REPORT__OSGI_WS:
				setOsgiWs(OSGI_WS_EDEFAULT);
				return;
			case IModelPackage.REPORT__OSGI_OS:
				setOsgiOs(OSGI_OS_EDEFAULT);
				return;
			case IModelPackage.REPORT__OSGI_OS_VERSION:
				setOsgiOsVersion(OSGI_OS_VERSION_EDEFAULT);
				return;
			case IModelPackage.REPORT__OSGI_ARCH:
				setOsgiArch(OSGI_ARCH_EDEFAULT);
				return;
			case IModelPackage.REPORT__PRESENT_BUNDLES:
				getPresentBundles().clear();
				return;
			case IModelPackage.REPORT__STATUS:
				setStatus((IStatus)null);
				return;
			case IModelPackage.REPORT__SEVERITY:
				setSeverity(SEVERITY_EDEFAULT);
				return;
			case IModelPackage.REPORT__AUXILIARY_INFORMATION:
				getAuxiliaryInformation().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IModelPackage.REPORT__ANONYMOUS_ID:
				return ANONYMOUS_ID_EDEFAULT == null ? anonymousId != null : !ANONYMOUS_ID_EDEFAULT.equals(anonymousId);
			case IModelPackage.REPORT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case IModelPackage.REPORT__EMAIL:
				return EMAIL_EDEFAULT == null ? email != null : !EMAIL_EDEFAULT.equals(email);
			case IModelPackage.REPORT__COMMENT:
				return COMMENT_EDEFAULT == null ? comment != null : !COMMENT_EDEFAULT.equals(comment);
			case IModelPackage.REPORT__ECLIPSE_BUILD_ID:
				return ECLIPSE_BUILD_ID_EDEFAULT == null ? eclipseBuildId != null : !ECLIPSE_BUILD_ID_EDEFAULT.equals(eclipseBuildId);
			case IModelPackage.REPORT__ECLIPSE_PRODUCT:
				return ECLIPSE_PRODUCT_EDEFAULT == null ? eclipseProduct != null : !ECLIPSE_PRODUCT_EDEFAULT.equals(eclipseProduct);
			case IModelPackage.REPORT__JAVA_RUNTIME_VERSION:
				return JAVA_RUNTIME_VERSION_EDEFAULT == null ? javaRuntimeVersion != null : !JAVA_RUNTIME_VERSION_EDEFAULT.equals(javaRuntimeVersion);
			case IModelPackage.REPORT__OSGI_WS:
				return OSGI_WS_EDEFAULT == null ? osgiWs != null : !OSGI_WS_EDEFAULT.equals(osgiWs);
			case IModelPackage.REPORT__OSGI_OS:
				return OSGI_OS_EDEFAULT == null ? osgiOs != null : !OSGI_OS_EDEFAULT.equals(osgiOs);
			case IModelPackage.REPORT__OSGI_OS_VERSION:
				return OSGI_OS_VERSION_EDEFAULT == null ? osgiOsVersion != null : !OSGI_OS_VERSION_EDEFAULT.equals(osgiOsVersion);
			case IModelPackage.REPORT__OSGI_ARCH:
				return OSGI_ARCH_EDEFAULT == null ? osgiArch != null : !OSGI_ARCH_EDEFAULT.equals(osgiArch);
			case IModelPackage.REPORT__PRESENT_BUNDLES:
				return presentBundles != null && !presentBundles.isEmpty();
			case IModelPackage.REPORT__STATUS:
				return status != null;
			case IModelPackage.REPORT__SEVERITY:
				return severity != SEVERITY_EDEFAULT;
			case IModelPackage.REPORT__AUXILIARY_INFORMATION:
				return auxiliaryInformation != null && !auxiliaryInformation.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (anonymousId: ");
		result.append(anonymousId);
		result.append(", name: ");
		result.append(name);
		result.append(", email: ");
		result.append(email);
		result.append(", comment: ");
		result.append(comment);
		result.append(", eclipseBuildId: ");
		result.append(eclipseBuildId);
		result.append(", eclipseProduct: ");
		result.append(eclipseProduct);
		result.append(", javaRuntimeVersion: ");
		result.append(javaRuntimeVersion);
		result.append(", osgiWs: ");
		result.append(osgiWs);
		result.append(", osgiOs: ");
		result.append(osgiOs);
		result.append(", osgiOsVersion: ");
		result.append(osgiOsVersion);
		result.append(", osgiArch: ");
		result.append(osgiArch);
		result.append(", severity: ");
		result.append(severity);
		result.append(')');
		return result.toString();
	}

} //ReportImpl
