/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import org.eclipse.emf.cdo.CDONotification;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOLazyContentAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;

public class CDOModificationTrackingAdapter
extends CDOLazyContentAdapter {
    private CDOResource container;

    public CDOModificationTrackingAdapter(CDOResource resource) {
        this.container = resource;
        InternalCDOTransaction transaction = ((InternalCDOView)resource.cdoView()).toTransaction();
        transaction.addTransactionHandler(new CDODefaultTransactionHandler(){

            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                CDOModificationTrackingAdapter.this.container.setModified(false);
            }

            public void rolledBackTransaction(CDOTransaction transaction) {
                if (!transaction.getLastSavepoint().wasDirty()) {
                    CDOModificationTrackingAdapter.this.container.setModified(false);
                }
            }
        });
    }

    public void notifyChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        if (notification instanceof CDONotification) {
            return;
        }
        Object notifier = notification.getNotifier();
        if (notifier == this.container) {
            if (notification.getFeature() == EresourcePackage.Literals.CDO_RESOURCE__CONTENTS) {
                this.container.setModified(true);
            }
        } else if (!(notifier instanceof Resource)) {
            this.container.setModified(true);
        }
    }
}

