/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.log.HttpTracer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class BaseClientRequest<T> {
    private final String label;

    public BaseClientRequest(String label) {
        Assert.isNotNull((Object)label);
        this.label = label;
    }

    public String getRequestLabel() {
        return this.label;
    }

    public T run(IProgressMonitor monitor) throws CoreException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)monitor);
        subProgress.subTask(this.getRequestLabel());
        CloudFoundryOperations client = this.getClient((IProgressMonitor)subProgress);
        if (client == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ERROR_NO_CLIENT, (Object)this.getRequestLabel()));
        }
        HttpTracer.getCurrent().trace(client);
        try {
            T t = this.runAndWait(client, subProgress);
            return t;
        }
        catch (CoreException ce) {
            String connectionError = CloudErrorUtil.getConnectionError(ce);
            if (connectionError != null) {
                throw CloudErrorUtil.asCoreException(connectionError, ce, true);
            }
            throw ce;
        }
        finally {
            subProgress.done();
        }
    }

    protected T runAndWait(CloudFoundryOperations client, SubMonitor subProgress) throws CoreException, OperationCanceledException {
        Throwable error = null;
        boolean reattempt = true;
        long timeLeft = this.getTotalTimeWait();
        while (reattempt) {
            long interval = -1L;
            try {
                return this.doRun(client, subProgress);
            }
            catch (Throwable e) {
                error = e;
                interval = this.waitOnErrorInterval(error, subProgress);
                boolean bl = reattempt = !subProgress.isCanceled() && (timeLeft -= interval) >= 0L && interval > 0L;
                if (!reattempt) continue;
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (subProgress.isCanceled()) {
            throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)this.label));
        }
        if (error instanceof OperationCanceledException) {
            throw (OperationCanceledException)error;
        }
        throw this.getErrorOnLastFailedAttempt(error);
    }

    protected CoreException getErrorOnLastFailedAttempt(Throwable error) {
        if (error instanceof CoreException) {
            return (CoreException)error;
        }
        return CloudErrorUtil.toCoreException(error);
    }

    protected long waitOnErrorInterval(Throwable exception, SubMonitor monitor) throws CoreException {
        return -1L;
    }

    protected abstract T doRun(CloudFoundryOperations var1, SubMonitor var2) throws CoreException;

    protected abstract CloudFoundryOperations getClient(IProgressMonitor var1) throws CoreException;

    protected long getTotalTimeWait() {
        return 15000L;
    }
}

