/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.HashMap;
import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CContainerValidator;

public class SourcesValidator
extends CContainerValidator {
    public static IFilter<INode> PARENTS = Filters.ACTIVITIES;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_SOURCE, 1, Integer.MAX_VALUE);
        this.checkChild(ND_TRANSITION_CONDITION, 0, 1);
    }

    @ARule(sa=68, desc="<source> elements must have distinct linkNames", author="michal.chmielewski@oracle.com", date="02/16/2007", errors="BPELC_DUPLICATE_NAME")
    public void rule_CheckUniqueSourceName_10() {
        HashMap<String, INode> map = new HashMap<String, INode>();
        List<INode> children = mSelector.selectNodes(this.mNode, ND_SOURCE);
        for (INode next : children) {
            String name = next.getAttribute(AT_LINK_NAME);
            INode present = (INode)map.get(next.getAttribute(AT_LINK_NAME));
            if (present == null) {
                map.put(name, next);
                continue;
            }
            IProblem problem = this.createError(next);
            problem.setAttribute("context.name", AT_LINK_NAME);
            problem.fill("BPELC_DUPLICATE_NAME", this.toString(this.mNode.nodeName()), next.nodeName(), name);
        }
        map.clear();
    }
}

