/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.MapRuleBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.MapHandleProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MapPreferencePage
extends BaseStylePreferencePage {
    private TableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fDeleteButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private MapHandleProvider provider = new MapHandleProvider();
    private Object model;
    private Button fDuplicateButton;

    public MapPreferencePage(Object model) {
        super(model);
        this.setTitle(Messages.getString((String)"MapPreferencePage.displayname.Title"));
        this.setDescription(Messages.getString((String)"MapPreferencePage.text.Description"));
        this.model = model;
    }

    protected Control createContents(Composite ancestor) {
        super.createFieldEditors();
        UIUtil.bindHelp((Control)ancestor, "org.eclipse.birt.cshelp.StyleBuilderMap_ID");
        final Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        final Table table = new Table(parent, 67584);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        final TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.getString((String)"MapPreferencePage.displayname.DisplayValue"));
        final TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.getString((String)"MapPreferencePage.displayname.Condition"));
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new MapContentProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MapPreferencePage.this.updateButtons();
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MapPreferencePage.this.edit();
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MapPreferencePage.this.handleTableKeyPressEvent(e);
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > width) {
                    column1.setWidth(width / 4);
                    column2.setWidth(width - column1.getWidth() - 50);
                } else {
                    column1.setWidth(width / 4);
                    column2.setWidth(width - column1.getWidth() - 50);
                }
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(128));
        layout = new GridLayout();
        layout.numColumns = 7;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(Messages.getString((String)"MapPreferencePage.text.Add"));
        data = new GridData(768);
        data.widthHint = Math.max(this.fAddButton.computeSize((int)-1, (int)-1).x, 60);
        this.fAddButton.setLayoutData((Object)data);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MapPreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(Messages.getString((String)"MapPreferencePage.text.Edit"));
        data = new GridData(768);
        data.widthHint = Math.max(this.fEditButton.computeSize((int)-1, (int)-1).x, 60);
        this.fEditButton.setLayoutData((Object)data);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MapPreferencePage.this.edit();
            }
        });
        this.fDeleteButton = new Button(buttons, 8);
        this.fDeleteButton.setText(Messages.getString((String)"MapPreferencePage.text.Delete"));
        data = new GridData(768);
        data.widthHint = Math.max(this.fDeleteButton.computeSize((int)-1, (int)-1).x, 60);
        this.fDeleteButton.setLayoutData((Object)data);
        this.fDeleteButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MapPreferencePage.this.delete();
            }
        });
        this.fMoveUpButton = new Button(buttons, 8);
        this.fMoveUpButton.setText(Messages.getString((String)"FormPage.Button.Up"));
        this.fMoveUpButton.setToolTipText(Messages.getString((String)"MapPreferencePage.toolTipText.Up"));
        data = new GridData(768);
        data.widthHint = Math.max(this.fMoveUpButton.computeSize((int)-1, (int)-1).x, 60);
        this.fMoveUpButton.setLayoutData((Object)data);
        this.fMoveUpButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MapPreferencePage.this.moveUp();
            }
        });
        this.fMoveDownButton = new Button(buttons, 8);
        this.fMoveDownButton.setText(Messages.getString((String)"FormPage.Button.Down"));
        this.fMoveDownButton.setToolTipText(Messages.getString((String)"MapPreferencePage.toolTipText.Down"));
        data = new GridData(768);
        data.widthHint = Math.max(this.fMoveDownButton.computeSize((int)-1, (int)-1).x, 60);
        this.fMoveDownButton.setLayoutData((Object)data);
        this.fMoveDownButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MapPreferencePage.this.moveDown();
            }
        });
        this.fDuplicateButton = new Button(buttons, 8);
        this.fDuplicateButton.setText(Messages.getString((String)"MapPreferencePage.text.Duplicate"));
        this.fDuplicateButton.setToolTipText(Messages.getString((String)"MapPreferencePage.toolTipText.Duplicate"));
        data = new GridData(768);
        data.widthHint = Math.max(this.fDuplicateButton.computeSize((int)-1, (int)-1).x, 60);
        this.fDuplicateButton.setLayoutData((Object)data);
        this.fDuplicateButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MapPreferencePage.this.duplicate();
            }
        });
        this.fTableViewer.setInput(this.model);
        this.updateButtons();
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void duplicate() {
        int index = this.fTableViewer.getTable().getSelectionIndex();
        PropertyHandle phandle = ((StyleHandle)this.model).getPropertyHandle("mapRules");
        MapRule rule = (MapRule)phandle.getListValue().get(index);
        try {
            MapRule newRule = (MapRule)rule.copy();
            phandle.addItem((IStructure)newRule);
            this.fTableViewer.add((Object)newRule.getHandle((SimpleValueHandle)phandle, phandle.getItems().size() - 1));
            int itemCount = this.fTableViewer.getTable().getItemCount();
            this.fTableViewer.getTable().deselectAll();
            this.fTableViewer.getTable().select(itemCount - 1);
            this.fTableViewer.getTable().setFocus();
            this.updateButtons();
            this.refreshTableItemView();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void refreshTableItemView() {
        int i = 0;
        while (i < this.fTableViewer.getTable().getItemCount()) {
            TableItem ti = this.fTableViewer.getTable().getItem(i);
            MapRuleHandle handle = (MapRuleHandle)ti.getData();
            ti.setText(0, this.provider.getColumnText(handle, 0));
            ti.setText(1, this.provider.getColumnText(handle, 1));
            ++i;
        }
        this.fTableViewer.getTable().setFocus();
    }

    private void updateButtons() {
        this.fEditButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fDeleteButton.setEnabled(this.fEditButton.getEnabled());
        this.fDuplicateButton.setEnabled(this.fEditButton.getEnabled());
        this.fMoveUpButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() > 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveDownButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount() - 1);
    }

    private void add() {
        MapRuleBuilder builder = new MapRuleBuilder(this.getShell(), MapRuleBuilder.DLG_TITLE_NEW, this.provider);
        builder.updateHandle(null, this.fTableViewer.getTable().getItemCount());
        builder.setDesignHandle((DesignElementHandle)this.model);
        if (this.model instanceof ReportItemHandle) {
            builder.setReportElement((ReportElementHandle)((ReportItemHandle)this.model));
        } else if (this.model instanceof GroupHandle) {
            builder.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)this.model).getContainer()));
        }
        if (builder.open() == 0) {
            this.fTableViewer.add((Object)builder.getHandle());
            int itemCount = this.fTableViewer.getTable().getItemCount();
            this.fTableViewer.getTable().deselectAll();
            this.fTableViewer.getTable().select(itemCount - 1);
            this.fTableViewer.getTable().setFocus();
            this.updateButtons();
            this.refreshTableItemView();
            this.getBuilder().refreshPagesStatus();
        }
    }

    private void edit() {
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
            MapRuleBuilder builder = new MapRuleBuilder(this.getShell(), MapRuleBuilder.DLG_TITLE_EDIT, this.provider);
            MapRuleHandle handle = (MapRuleHandle)this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex()).getData();
            builder.updateHandle(handle, this.fTableViewer.getTable().getItemCount());
            builder.setDesignHandle((DesignElementHandle)this.model);
            if (this.model instanceof ReportItemHandle) {
                builder.setReportElement((ReportElementHandle)((ReportItemHandle)this.model));
            } else if (this.model instanceof GroupHandle) {
                builder.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)this.model).getContainer()));
            }
            if (builder.open() == 0) {
                this.updateButtons();
                this.refreshTableItemView();
            }
        }
    }

    private void delete() {
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
            int idx = this.fTableViewer.getTable().getSelectionIndex();
            try {
                this.provider.doDeleteItem(idx);
                this.fTableViewer.getTable().remove(idx);
                this.fTableViewer.refresh();
                if (idx >= this.fTableViewer.getTable().getItemCount()) {
                    --idx;
                }
                this.fTableViewer.getTable().select(idx);
                this.refreshTableItemView();
            }
            catch (Exception e) {
                WidgetUtil.processError(this.getShell(), e);
            }
            this.updateButtons();
            this.getBuilder().refreshPagesStatus();
        }
    }

    private void moveUp() {
        int index = this.fTableViewer.getTable().getSelectionIndex();
        try {
            this.provider.doSwapItem(index, -1);
            Object handle = this.fTableViewer.getTable().getItem(index).getData();
            this.fTableViewer.remove(handle);
            this.fTableViewer.insert(handle, index - 1);
            this.fTableViewer.refresh();
            this.fTableViewer.getTable().select(index - 1);
            this.refreshTableItemView();
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        this.updateButtons();
    }

    private void moveDown() {
        int index = this.fTableViewer.getTable().getSelectionIndex();
        try {
            this.provider.doSwapItem(index, 1);
            Object handle = this.fTableViewer.getTable().getItem(index).getData();
            this.fTableViewer.remove(handle);
            this.fTableViewer.insert(handle, index + 1);
            this.fTableViewer.refresh();
            this.fTableViewer.getTable().select(index + 1);
            this.refreshTableItemView();
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        this.updateButtons();
    }

    protected void handleTableKeyPressEvent(KeyEvent e) {
        if (e.keyCode == 127) {
            this.delete();
        }
    }

    @Override
    protected String[] getPreferenceNames() {
        return new String[0];
    }

    @Override
    public boolean hasLocaleProperties() {
        PropertyHandle phandle = ((StyleHandle)this.model).getPropertyHandle("mapRules");
        return phandle.getListValue() != null && phandle.getListValue().size() > 0;
    }

    class MapContentProvider
    implements IStructuredContentProvider {
        MapContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = MapPreferencePage.this.provider.getElements(inputElement);
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return MapPreferencePage.this.provider.getColumnText(element, columnIndex);
        }
    }
}

