/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.IElementDropAdapter;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.swt.dnd.TransferData;

public class SlotHandleDropAdapter
implements IElementDropAdapter {
    public boolean validateDrop(Object target, int operation, int location, Object transfer, TransferData transferType) {
        return TemplateTransfer.getInstance().isSupportedType(transferType);
    }

    public boolean handleDrop(Object target, int operation, int location, Object transfer) {
        int canContain = DNDUtil.handleValidateTargetCanContain((Object)target, (Object)transfer, (location != 3 ? 1 : 0) != 0);
        if (operation == 2) {
            int position;
            if (Policy.TRACING_DND_DRAG) {
                System.out.println("DND >> Dropped. Operation: Copy, Target: " + target);
            }
            if ((position = DNDUtil.calculateNextPosition((Object)target, (int)canContain)) > -1) {
                target = DNDUtil.getDesignElementHandle((Object)target).getContainerSlotHandle();
                if (location == 1) {
                    --position;
                }
            }
            return DNDUtil.moveHandles((Object)transfer, (Object)target, (int)position);
        }
        if (operation == 1) {
            boolean result;
            block23: {
                int position;
                if (Policy.TRACING_DND_DRAG) {
                    System.out.println("DND >> Dropped. Operation: Move, Target: " + target);
                }
                if ((position = DNDUtil.calculateNextPosition((Object)target, (int)canContain)) > -1) {
                    target = DNDUtil.getDesignElementHandle((Object)target).getContainerSlotHandle();
                    if (location == 1) {
                        --position;
                    }
                }
                result = false;
                Object transferFirstElement = this.getSingleTransferData(transfer);
                if (transferFirstElement != null && transferFirstElement instanceof DesignElementHandle) {
                    DesignElementHandle sourceHandle = (DesignElementHandle)transferFirstElement;
                    if (sourceHandle.getRoot() instanceof LibraryHandle) {
                        LibraryHandle library = (LibraryHandle)sourceHandle.getRoot();
                        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                        try {
                            if (moduleHandle != library) {
                                if (UIUtil.includeLibrary((ModuleHandle)moduleHandle, (LibraryHandle)library)) {
                                    DNDUtil.addElementHandle((Object)target, (DesignElementHandle)moduleHandle.getElementFactory().newElementFrom(sourceHandle, sourceHandle.getName()));
                                    result = true;
                                }
                                break block23;
                            }
                            result = DNDUtil.copyHandles((Object)transfer, (Object)target, (int)position);
                        }
                        catch (Exception e) {
                            ExceptionUtil.handle((Throwable)e);
                        }
                    } else {
                        result = DNDUtil.copyHandles((Object)transfer, (Object)target, (int)position);
                    }
                } else if (transferFirstElement != null && transferFirstElement instanceof EmbeddedImageHandle) {
                    EmbeddedImageHandle sourceEmbeddedImageHandle = (EmbeddedImageHandle)transferFirstElement;
                    if (sourceEmbeddedImageHandle.getElementHandle().getRoot() instanceof LibraryHandle) {
                        LibraryHandle library = (LibraryHandle)sourceEmbeddedImageHandle.getElementHandle().getRoot();
                        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                        try {
                            if (moduleHandle != library) {
                                if (UIUtil.includeLibrary((ModuleHandle)moduleHandle, (LibraryHandle)library)) {
                                    EmbeddedImage image = StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)sourceEmbeddedImageHandle, (ModuleHandle)moduleHandle);
                                    image.setType(sourceEmbeddedImageHandle.getType());
                                    DNDUtil.addEmbeddedImageHandle((Object)target, (EmbeddedImage)image);
                                    result = true;
                                }
                                break block23;
                            }
                            result = DNDUtil.copyHandles((Object)transfer, (Object)target, (int)position);
                        }
                        catch (Exception e) {
                            ExceptionUtil.handle((Throwable)e);
                        }
                    } else {
                        result = DNDUtil.copyHandles((Object)transfer, (Object)target, (int)position);
                    }
                }
            }
            return result;
        }
        return false;
    }

    private Object getSingleTransferData(Object template) {
        if (template instanceof Object[]) {
            return ((Object[])template)[0];
        }
        return template;
    }
}

