/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistryListener2;
import org.eclipse.sirius.business.internal.migration.resource.ResourceFileExtensionPredicate;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class SessionVSMUpdater
implements ViewpointRegistryListener2 {
    private final DAnalysisSessionImpl session;

    public SessionVSMUpdater(DAnalysisSessionImpl session) {
        this.session = (DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session);
    }

    @Override
    public void modelerDesciptionFilesLoaded() {
        ArrayList allResources = new ArrayList(this.session.getTransactionalEditingDomain().getResourceSet().getResources());
        for (Resource res : Iterables.filter(allResources, (Predicate)new ResourceFileExtensionPredicate("odesign", false))) {
            if (!res.isModified() && res.isLoaded() && res.getContents().isEmpty()) {
                this.session.unregisterResourceInCrossReferencer(res);
                res.unload();
            }
            IFile correspondingFile = WorkspaceSynchronizer.getFile((Resource)res);
            if (!res.isLoaded() && correspondingFile != null && correspondingFile.exists()) {
                try {
                    res.load(Collections.emptyMap());
                    if (!res.isLoaded() || res.getContents().isEmpty()) continue;
                    this.session.registerResourceInCrossReferencer(res);
                    InterpreterRegistry.prepareImportsFromSession(this.session.getInterpreter(), this.session);
                }
                catch (IOException e) {
                    SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.SessionVSMUpdater_VSMLoadErrorMsg, res.getURI()), e);
                }
                continue;
            }
            if (!res.getURI().isPlatformPlugin()) continue;
            if (res.isLoaded()) {
                res.unload();
            }
            try {
                res.load(Collections.emptyMap());
                if (!res.isLoaded() || res.getContents().isEmpty()) continue;
                this.session.registerResourceInCrossReferencer(res);
                InterpreterRegistry.prepareImportsFromSession(this.session.getInterpreter(), this.session);
            }
            catch (IOException e) {
                SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.SessionVSMUpdater_VSMLoadErrorMsg, res.getURI()), e);
            }
        }
        this.session.notifyListeners(16);
    }
}

