/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;

public class QVTimperativeUtil
extends QVTbaseUtil {
    public static @Nullable ImperativeTransformation basicGetContainingTransformation(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof ImperativeTransformation) {
                return (ImperativeTransformation)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable ImperativeTypedModel basicGetOwnedTypedModel(@NonNull ImperativeTransformation transformation, @Nullable String name) {
        return (ImperativeTypedModel)NameUtil.getNameable(QVTimperativeUtil.getOwnedTypedModels(transformation), (String)name);
    }

    public static @NonNull Class getClassType(@NonNull TypedElement typedElement) {
        return (Class)ClassUtil.nonNullState((Object)((Class)typedElement.getType()));
    }

    public static @Nullable Mapping getContainingMapping(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Mapping) {
                return (Mapping)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Statement getContainingStatement(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Statement) {
                return (Statement)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @NonNull ImperativeTransformation getContainingTransformation(@Nullable EObject eObject) {
        return (ImperativeTransformation)ClassUtil.nonNullState((Object)QVTimperativeUtil.basicGetContainingTransformation(eObject));
    }

    public static @NonNull String getName(@NonNull Mapping asMapping) {
        return (String)ClassUtil.nonNullState((Object)asMapping.getName());
    }

    public static @NonNull String getName(@NonNull MappingParameter asParameter) {
        return (String)ClassUtil.nonNullState((Object)asParameter.getName());
    }

    public static @NonNull Iterable<@NonNull Property> getObservedProperties(@NonNull ObservableStatement observableStatement) {
        return ClassUtil.nullFree(observableStatement.getObservedProperties());
    }

    public static @NonNull Mapping getOwnedMapping(@NonNull ImperativeTransformation transformation, @Nullable String name) {
        return (Mapping)ClassUtil.nonNullState((Object)((Mapping)NameUtil.getNameable(QVTimperativeUtil.getOwnedMappings(transformation), (String)name)));
    }

    public static @NonNull Iterable<@NonNull MappingParameterBinding> getOwnedMappingParameterBindings(@NonNull MappingCall mappingCall) {
        EList<MappingParameterBinding> ownedParameters = mappingCall.getOwnedMappingParameterBindings();
        return (Iterable)ownedParameters;
    }

    public static @NonNull Iterable<@NonNull MappingParameter> getOwnedMappingParameters(@NonNull Mapping mapping) {
        EList<MappingParameter> ownedParameters = mapping.getOwnedMappingParameters();
        return (Iterable)ownedParameters;
    }

    public static @NonNull Iterable<@NonNull Mapping> getOwnedMappings(@NonNull ImperativeTransformation transformation) {
        EList rule = transformation.getRule();
        return (Iterable)rule;
    }

    public static @NonNull ImperativeTypedModel getOwnedTypedModel(@NonNull ImperativeTransformation transformation, @Nullable String name) {
        return (ImperativeTypedModel)ClassUtil.nonNullState((Object)((ImperativeTypedModel)NameUtil.getNameable(QVTimperativeUtil.getOwnedTypedModels(transformation), (String)name)));
    }

    public static @NonNull Iterable<@NonNull ImperativeTypedModel> getOwnedTypedModels(@NonNull ImperativeTransformation transformation) {
        EList modelParameter = transformation.getModelParameter();
        return (Iterable)modelParameter;
    }

    public static @NonNull Mapping getReferredMapping(MappingCall asMappingCall) {
        return (Mapping)ClassUtil.nonNullState((Object)asMappingCall.getReferredMapping());
    }

    public static @NonNull Mapping getRootMapping(@NonNull ImperativeTransformation asTransformation) {
        Mapping asRootMapping = (Mapping)NameUtil.getNameable(QVTimperativeUtil.getOwnedMappings(asTransformation), (String)"\u00abroot\u00bb");
        for (Mapping asMapping : QVTimperativeUtil.getOwnedMappings(asTransformation)) {
            boolean isRoot = true;
            for (MappingParameter asParameter : QVTimperativeUtil.getOwnedMappingParameters(asMapping)) {
                if (asParameter instanceof GuardParameter) {
                    isRoot = false;
                    break;
                }
                if (!(asParameter instanceof SimpleParameter)) continue;
                isRoot = false;
                break;
            }
            if (!isRoot) continue;
            if (asRootMapping == null) {
                asRootMapping = asMapping;
                continue;
            }
            if (asRootMapping == asMapping) continue;
            throw new IllegalStateException("Transformation " + asTransformation.getName() + " has ambiguous root mappings: " + asRootMapping + ", " + asMapping);
        }
        if (asRootMapping == null) {
            throw new IllegalStateException("Transformation " + asTransformation.getName() + " has no root mapping");
        }
        return asRootMapping;
    }

    public static @NonNull Property getTargetProperty(@NonNull SetStatement asSetStatement) {
        Property referredProperty = (Property)ClassUtil.nonNullState((Object)asSetStatement.getTargetProperty());
        if (asSetStatement.isIsOpposite()) {
            if (referredProperty.eIsProxy()) {
                throw new IllegalStateException("Unresolved target property proxy '" + EcoreUtil.getURI((EObject)referredProperty) + "' at '" + EcoreUtil.getURI((EObject)asSetStatement) + "'");
            }
            return (Property)ClassUtil.nonNullState((Object)referredProperty.getOpposite());
        }
        return referredProperty;
    }

    public static boolean isObserver(@NonNull Mapping asMapping) {
        boolean isHazardous = false;
        for (Statement asStatement : ClassUtil.nullFree(asMapping.getOwnedStatements())) {
            if (!(asStatement instanceof ObservableStatement) || ((ObservableStatement)asStatement).getObservedProperties().size() <= 0) continue;
            return true;
        }
        return isHazardous;
    }

    public static boolean isPrimitiveVariable(@NonNull VariableDeclaration asVariable) {
        return !(asVariable.getType() instanceof CollectionType);
    }

    public static @NonNull ImperativeTransformation loadTransformation(@NonNull QVTbaseEnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = environmentFactory.setCreateStrategy(QVTiEnvironmentFactory.CREATE_STRATEGY);
        try {
            ImperativeTransformation imperativeTransformation = (ImperativeTransformation)QVTimperativeUtil.loadTransformation(ImperativeModel.class, (EnvironmentFactory)environmentFactory, (URI)transformationURI, (boolean)keepDebug);
            return imperativeTransformation;
        }
        finally {
            environmentFactory.setCreateStrategy(savedStrategy);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void sortPatternVariables(@NonNull List<@NonNull ? extends Variable> variables) {
        if (variables.size() > 1) {
            boolean bl;
            HashMap<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs = new HashMap<Variable, List<VariableDeclaration>>();
            for (Variable variable : variables) {
                def2refs.put(variable, null);
            }
            for (Variable variable : variables) {
                ArrayList<VariableDeclaration> refs = null;
                OCLExpression initExpression = variable.getOwnedInit();
                if (initExpression == null) continue;
                for (EObject eObject : new TreeIterable((EObject)initExpression, true)) {
                    if (!(eObject instanceof VariableExp)) continue;
                    VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                    assert (referredVariable != null);
                    if (!def2refs.containsKey(referredVariable)) continue;
                    if (refs == null) {
                        refs = new ArrayList<VariableDeclaration>();
                        def2refs.put(variable, refs);
                    }
                    if (refs.contains(referredVariable)) continue;
                    refs.add(referredVariable);
                }
            }
            boolean bl2 = true;
            while (bl) {
                bl = false;
                for (Variable variable : def2refs.keySet()) {
                    @NonNull List refs = (List)def2refs.get(variable);
                    if (refs == null) continue;
                    int i = 0;
                    while (i < refs.size()) {
                        VariableDeclaration ref = (VariableDeclaration)refs.get(i);
                        @NonNull List refRefs = (List)def2refs.get(ref);
                        if (refRefs != null) {
                            for (VariableDeclaration refRef : refRefs) {
                                if (refs.contains(refRef)) continue;
                                refs.add(refRef);
                                bl = true;
                            }
                        }
                        ++i;
                    }
                }
            }
            ClassUtil.sort(variables, (Comparator)new PatternVariableComparator(def2refs));
        }
    }

    public static @NonNull MappingCall getOwningMappingCall(@NonNull MappingParameterBinding mappingParameterBinding) {
        return (MappingCall)ClassUtil.nonNullState((Object)mappingParameterBinding.getOwningMappingCall());
    }

    public static final class MappingParameterBindingComparator
    implements Comparator<MappingParameterBinding> {
        public static final @NonNull MappingParameterBindingComparator INSTANCE = new MappingParameterBindingComparator();

        @Override
        public int compare(@NonNull MappingParameterBinding o1, @NonNull MappingParameterBinding o2) {
            MappingParameter v1 = o1.getBoundVariable();
            MappingParameter v2 = o2.getBoundVariable();
            String n1 = v1 != null ? v1.getName() : null;
            String n2 = v2 != null ? v2.getName() : null;
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }

    protected static class PatternVariableComparator
    implements Comparator<Variable> {
        private final @NonNull Map<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs;

        protected PatternVariableComparator(@NonNull Map<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs) {
            this.def2refs = def2refs;
        }

        @Override
        public int compare(@NonNull Variable o1, @NonNull Variable o2) {
            int s2;
            List<@NonNull VariableDeclaration> l1 = this.def2refs.get(o1);
            List<@NonNull VariableDeclaration> l2 = this.def2refs.get(o2);
            int s1 = l1 != null ? l1.size() : 0;
            int n = s2 = l2 != null ? l2.size() : 0;
            if (s1 != s2) {
                return s1 - s2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

