/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.BundleManifestSourceLocationManager;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocation;
import org.osgi.framework.Version;

public class SourceLocationManager
implements ICoreConstants {
    private List<SourceLocation> fExtensionLocations = null;
    private BundleManifestSourceLocationManager fBundleManifestLocator = null;

    public IPath findSourcePath(IPluginBase pluginBase, IPath sourceLibraryPath) {
        if (pluginBase.getId() == null || pluginBase.getVersion() == null) {
            return null;
        }
        IPath relativePath = this.getRelativePath(pluginBase, sourceLibraryPath);
        IPath result = this.searchUserSpecifiedLocations(relativePath);
        if (result == null && (result = this.searchBundleManifestLocations(pluginBase)) == null) {
            result = this.searchExtensionLocations(relativePath);
        }
        return result;
    }

    public URL findSourceFile(IPluginBase pluginBase, IPath filePath) {
        if (pluginBase.getId() == null || pluginBase.getVersion() == null) {
            return null;
        }
        IPath relativePath = this.getRelativePath(pluginBase, filePath);
        IPath result = this.searchUserSpecifiedLocations(relativePath);
        if (result == null) {
            result = this.searchBundleManifestLocations(pluginBase);
            if (result != null) {
                try {
                    URI encodedUri = URIUtil.toURI((URL)result.toFile().toURL());
                    URI jarUri = URIUtil.toJarURI((URI)encodedUri, (IPath)filePath);
                    return new URL(URIUtil.toUnencodedString((URI)jarUri));
                }
                catch (MalformedURLException e) {
                    PDECore.log(e);
                }
                catch (URISyntaxException e) {
                    PDECore.log(e);
                }
            }
            result = this.searchExtensionLocations(relativePath);
        }
        if (result != null) {
            try {
                return result.toFile().toURL();
            }
            catch (MalformedURLException e) {
                PDECore.log(e);
            }
        }
        return null;
    }

    public File findSourcePlugin(IPluginBase pluginBase) {
        if (pluginBase.getId() == null || pluginBase.getVersion() == null) {
            return null;
        }
        IPath path = this.findSourcePath(pluginBase, null);
        return path == null ? null : path.toFile();
    }

    public boolean hasBundleManifestLocation(IPluginBase plugin) {
        if (plugin.getId() == null || plugin.getVersion() == null) {
            return false;
        }
        return this.getBundleManifestLocator().hasValidSourceLocation(plugin.getId(), new Version(plugin.getVersion()));
    }

    public Set<String> findAllSourceRootsInSourceLocation(IPluginBase plugin) {
        if (plugin.getId() == null || plugin.getVersion() == null) {
            return Collections.emptySet();
        }
        return this.getBundleManifestLocator().getAllSourceRoots(plugin.getId(), new Version(plugin.getVersion()));
    }

    public Set<String> findSourceRoots(IPluginBase plugin) {
        if (plugin.getId() == null || plugin.getVersion() == null) {
            return Collections.emptySet();
        }
        return this.getBundleManifestLocator().getSourceRoots(plugin.getId(), new Version(plugin.getVersion()));
    }

    public void reset() {
        this.fExtensionLocations = null;
        this.fBundleManifestLocator = null;
    }

    public List<SourceLocation> getUserLocations() {
        ArrayList<SourceLocation> userLocations = new ArrayList<SourceLocation>();
        String pref = PDECore.getDefault().getPreferencesManager().getString("source_locations");
        if (pref.length() > 0) {
            this.parseSavedSourceLocations(pref, userLocations);
        }
        return userLocations;
    }

    public List<SourceLocation> getExtensionLocations() {
        if (this.fExtensionLocations == null) {
            this.fExtensionLocations = SourceLocationManager.processExtensions();
        }
        return this.fExtensionLocations;
    }

    public Collection<SourceLocation> getBundleManifestLocations() {
        return this.getBundleManifestLocator().getSourceLocations();
    }

    private SourceLocation getBundleManifestLocation(String pluginID, Version version) {
        return this.getBundleManifestLocator().getSourceLocation(pluginID, version);
    }

    private BundleManifestSourceLocationManager getBundleManifestLocator() {
        if (this.fBundleManifestLocator == null) {
            this.fBundleManifestLocator = this.initializeBundleManifestLocations();
        }
        return this.fBundleManifestLocator;
    }

    private IPath getRelativePath(IPluginBase pluginBase, IPath sourceFilePath) {
        String pluginDir;
        block4: {
            try {
                pluginDir = pluginBase.getId();
                if (pluginDir != null) break block4;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        String version = pluginBase.getVersion();
        if (version != null) {
            Version vid = new Version(version);
            pluginDir = String.valueOf(pluginDir) + "_" + vid.toString();
        }
        Path path = new Path(pluginDir);
        return sourceFilePath == null ? path : path.append(sourceFilePath);
    }

    private IPath searchUserSpecifiedLocations(IPath relativePath) {
        List<SourceLocation> userLocations = this.getUserLocations();
        for (SourceLocation location : userLocations) {
            IPath fullPath = location.getPath().append(relativePath);
            File file = fullPath.toFile();
            if (!file.exists()) continue;
            return fullPath;
        }
        return null;
    }

    private IPath searchExtensionLocations(IPath relativePath) {
        List<SourceLocation> extensionLocations = this.getExtensionLocations();
        for (SourceLocation location : extensionLocations) {
            IPath fullPath = location.getPath().append(relativePath);
            File file = fullPath.toFile();
            if (!file.exists()) continue;
            return fullPath;
        }
        return null;
    }

    private IPath searchBundleManifestLocations(IPluginBase pluginBase) {
        SourceLocation location = this.getBundleManifestLocation(pluginBase.getId(), new Version(pluginBase.getVersion()));
        if (location != null && location.getPath().toFile().exists()) {
            return location.getPath();
        }
        return null;
    }

    private void parseSavedSourceLocations(String text, List<SourceLocation> entries) {
        text = text.replace(File.pathSeparatorChar, ';');
        StringTokenizer stok = new StringTokenizer(text, ";");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            SourceLocation location = this.parseSourceLocation(token);
            if (location == null) continue;
            entries.add(location);
        }
    }

    private SourceLocation parseSourceLocation(String text) {
        String path;
        try {
            text = text.trim();
            int commaIndex = text.lastIndexOf(44);
            if (commaIndex == -1) {
                return new SourceLocation((IPath)new Path(text));
            }
            int atLoc = text.indexOf(64);
            path = atLoc == -1 ? text.substring(0, commaIndex) : text.substring(atLoc + 1, commaIndex);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        return new SourceLocation((IPath)new Path(path));
    }

    private static List<SourceLocation> processExtensions() {
        IExtension[] extensions;
        ArrayList<SourceLocation> result = new ArrayList<SourceLocation>();
        IExtension[] iExtensionArray = extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions("org.eclipse.pde.core.source", false);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] children = extension.getConfigurationElements();
            RegistryContributor contributor = (RegistryContributor)extension.getContributor();
            long bundleId = Long.parseLong(contributor.getActualId());
            BundleDescription desc = PDECore.getDefault().getModelManager().getState().getState().getBundle(Long.parseLong(contributor.getActualId()));
            IPluginModelBase base = null;
            if (desc != null) {
                base = PluginRegistry.findModel(desc);
            } else {
                IPluginModelBase[] externalModels;
                ModelEntry entry = PluginRegistry.findEntry(contributor.getActualName());
                IPluginModelBase[] iPluginModelBaseArray = externalModels = entry.getExternalModels();
                int n3 = externalModels.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginModelBase externalModel = iPluginModelBaseArray[n4];
                    BundleDescription extDesc = externalModel.getBundleDescription();
                    if (extDesc != null && extDesc.getBundleId() == bundleId) {
                        base = externalModel;
                    }
                    ++n4;
                }
            }
            if (base != null) {
                IConfigurationElement[] iConfigurationElementArray = children;
                int n5 = children.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement element = iConfigurationElementArray[n6];
                    if (element.getName().equals("location")) {
                        String pathValue = element.getAttribute("path");
                        IPath path = new Path(base.getInstallLocation()).append(pathValue);
                        if (path.toFile().exists()) {
                            SourceLocation location = new SourceLocation(path);
                            location.setUserDefined(false);
                            if (!result.contains(location)) {
                                result.add(location);
                            }
                        }
                    }
                    ++n6;
                }
            }
            ++n2;
        }
        return result;
    }

    protected BundleManifestSourceLocationManager initializeBundleManifestLocations() {
        BundleManifestSourceLocationManager manager = new BundleManifestSourceLocationManager();
        manager.setPlugins(PDECore.getDefault().getModelManager().getExternalModels());
        return manager;
    }
}

