/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.util;

import java.net.URL;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.Icons;

public final class ObjectTreeFactory {

    private static class Node {
        int ownId;
        String attributeName;
        List<Node> children;
        boolean isExpanded;
        boolean isSelected;

        private Node(int ownId) {
            this.ownId = ownId;
        }

        Node getOrCreateChild(int childId) {
            Node child = null;
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            } else {
                for (Node c : this.children) {
                    if (c.ownId != childId) continue;
                    child = c;
                    break;
                }
            }
            if (child == null) {
                child = new Node(childId);
                this.children.add(child);
            }
            return child;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeResult
    implements IResultTree,
    IIconProvider,
    ISelectionProvider {
        private static final Column COL_HEAP = new Column(Messages.Column_ShallowHeap, Bytes.class);
        private static final Column COL_RETAINED = new Column(Messages.Column_RetainedHeap, Bytes.class);
        private static final Column COL_PERCENT = new Column(Messages.ObjectTreeFactory_Column_Percentage, Double.TYPE).formatting((Format)new DecimalFormat("0.00%"));
        private ISnapshot snapshot;
        private Node invisibleRoot;
        private long base;
        private boolean decorateWithAttributeName;
        private Boolean incoming;

        private NodeResult(ISnapshot snapshot, Node root, long base, boolean decorateWithAttributeName, Boolean incoming) {
            this.snapshot = snapshot;
            this.invisibleRoot = root;
            this.base = base;
            this.decorateWithAttributeName = decorateWithAttributeName;
            this.incoming = incoming;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            Column classNameCol = new Column(Messages.Column_ClassName, String.class);
            if (this.decorateWithAttributeName) {
                classNameCol.decorator(new IDecorator(){

                    public String prefix(Object row) {
                        return ((Node)row).attributeName;
                    }

                    public String suffix(Object row) {
                        return null;
                    }
                });
            }
            if (this.base > 0L) {
                return new Column[]{classNameCol, COL_HEAP, COL_RETAINED, COL_PERCENT};
            }
            return new Column[]{classNameCol, COL_HEAP, COL_RETAINED};
        }

        public List<?> getElements() {
            return this.invisibleRoot.children;
        }

        public boolean hasChildren(Object element) {
            return ((Node)element).children != null;
        }

        public List<?> getChildren(Object parent) {
            return ((Node)parent).children;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            try {
                Node node = (Node)row;
                switch (columnIndex) {
                    case 0: {
                        return this.snapshot.getObject(node.ownId).getDisplayName();
                    }
                    case 1: {
                        return new Bytes(this.snapshot.getHeapSize(node.ownId));
                    }
                    case 2: {
                        return new Bytes(this.snapshot.getRetainedHeapSize(node.ownId));
                    }
                    case 3: {
                        long size = this.snapshot.getRetainedHeapSize(node.ownId);
                        return (double)size / (double)this.base;
                    }
                }
                return null;
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public URL getIcon(Object row) {
            if (this.incoming == null) {
                return Icons.forObject(this.snapshot, ((Node)row).ownId);
            }
            if (this.incoming.booleanValue()) {
                boolean isFirstLevel = this.invisibleRoot.children.contains(row);
                return isFirstLevel ? Icons.forObject(this.snapshot, ((Node)row).ownId) : Icons.inbound(this.snapshot, ((Node)row).ownId);
            }
            return Icons.outbound(this.snapshot, ((Node)row).ownId);
        }

        public boolean isExpanded(Object row) {
            return ((Node)row).isExpanded;
        }

        public boolean isSelected(Object row) {
            return ((Node)row).isSelected;
        }

        public IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((Node)row).ownId;
                }
            };
        }
    }

    public static class TreePathBuilder {
        private Node root = new Node(-1);
        private Node branch = null;
        private long base;
        private Boolean incoming;

        public TreePathBuilder() {
        }

        public TreePathBuilder(long base) {
            this.base = base;
        }

        public TreePathBuilder setIsIncoming() {
            this.incoming = Boolean.TRUE;
            return this;
        }

        public TreePathBuilder setIsOutgoing() {
            this.incoming = Boolean.FALSE;
            return this;
        }

        public TreePathBuilder addBranch(int objectId) {
            this.branch = this.root.getOrCreateChild(objectId);
            return this;
        }

        public TreePathBuilder addChild(int objectId, boolean select) {
            if (this.branch == null) {
                throw new RuntimeException(Messages.ObjectTreeFactory_ErrorMsg_addChild);
            }
            this.branch.isExpanded = true;
            this.branch = this.branch.getOrCreateChild(objectId);
            this.branch.isSelected = select;
            return this;
        }

        public TreePathBuilder addChildren(int[] objectIds) {
            if (this.branch == null) {
                throw new RuntimeException(Messages.ObjectTreeFactory_ErrorMsg_addChildren);
            }
            this.branch.isExpanded = true;
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                this.branch = this.branch.getOrCreateChild(id);
                ++n2;
            }
            return this;
        }

        public TreePathBuilder addSibling(int objectId, boolean select) {
            if (this.branch == null) {
                throw new RuntimeException(Messages.ObjectTreeFactory_ErrorMsg_addChild);
            }
            this.branch.isExpanded = true;
            this.branch.getOrCreateChild(objectId);
            this.branch.isSelected = select;
            return this;
        }

        public IResultTree build(ISnapshot snapshot) {
            return new NodeResult(snapshot, this.root, this.base, false, this.incoming);
        }
    }
}

