/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessage;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessageEx;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.IUriGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.OptionalFileGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TraceFileControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.TransformationSignatureLaunchControl;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.ApplyTransformationData;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationParametersPage
extends WizardPage {
    private final ISetMessageEx SET_MESSAGE = new ISetMessageEx(){

        public void setErrorMessage(String message) {
            TransformationParametersPage.this.setErrorMessage(message);
        }

        public void setWarningMessage(String message) {
            TransformationParametersPage.this.setMessage(message, 2);
        }

        public void setMessage(String message) {
            TransformationParametersPage.this.setMessage(message);
        }
    };
    private QvtTransformation myTransformation;
    private final ApplyTransformationData myData;
    private final List<IUriGroup.IModifyListener> myUriListeners = new ArrayList<IUriGroup.IModifyListener>(1);
    private TraceFileControl myTraceFile;
    private boolean myTraceNameNonChanged;
    private boolean isSkipValidation;
    private TransformationSignatureLaunchControl myTransfSignatureControl;
    private List<TargetUriData> myInitialTargetUris;
    private Button myOpenEditor;

    public TransformationParametersPage(String pageId, ApplyTransformationData data) {
        super(pageId);
        this.setDescription(Messages.TransformationParametersPage_Description);
        this.myData = data;
    }

    public void setTransformation(QvtTransformation transformation, List<TargetUriData> targetUris) {
        this.isSkipValidation = true;
        this.myInitialTargetUris = targetUris;
        this.myTransformation = transformation;
        if (this.myTransformation != null) {
            this.setTitle(NLS.bind((String)Messages.TransformationParametersPage_TitleWithTransf, (Object)this.myTransformation));
        }
        if (this.myTransfSignatureControl != null) {
            this.myTransfSignatureControl.setTransformation(this.myTransformation, this.myUriListeners);
        }
        if (this.myTransfSignatureControl != null && this.myTransformation != null) {
            try {
                this.applyTargetUris(this.initTargetUriData());
            }
            catch (MdaException mdaException) {
                // empty catch block
            }
        }
        this.myOpenEditor.setSelection(this.myData.isOpenResult());
        if (this.myData.getTraceFile().length() > 0) {
            this.myTraceFile.setText(this.myData.getTraceFile());
        } else {
            this.myTraceNameNonChanged = true;
            this.initTraceFileText();
        }
        this.myTraceFile.setUseFileFlag(this.myData.isUseTraceFile());
        this.myTraceFile.setIncrementalUpdate(this.myData.isIncrementalUpdate());
        this.isSkipValidation = false;
        this.performPageValidation();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        this.createTransformationSection(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createTransformationSection(Composite parent) {
        this.myTraceFile = new TraceFileControl(parent, org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages.QvtLauncherTab_TraceFile);
        this.myTraceFile.addModifyListener(new OptionalFileGroup.IModifyListener(){

            public void modified() {
                TransformationParametersPage.this.myTraceNameNonChanged = TransformationParametersPage.this.myTraceFile.getText().equals(TransformationParametersPage.this.getTraceFileName());
                TransformationParametersPage.this.performPageValidation();
            }
        });
        this.myUriListeners.add(new IUriGroup.IModifyListener(){

            public void modified() {
                TransformationParametersPage.this.initTraceFileText();
                TransformationParametersPage.this.performPageValidation();
            }

            public void performValidation(boolean isLightweight) {
                TransformationParametersPage.this.validatePage(QvtValidator.ValidationType.FULL_VALIDATION);
            }
        });
        TransformationControls.createLabel((Composite)parent, (String)org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages.QvtLauncherTab_ParametersLabel, (int)2);
        this.myTransfSignatureControl = new TransformationSignatureLaunchControl(parent, 2048);
        TransformationControls.createLabel((Composite)parent, (String)"", (int)2);
        this.myOpenEditor = new Button(parent, 32);
        this.myOpenEditor.setText(Messages.ApplyTransformationFinalPage_OpenEditor);
        this.myOpenEditor.setSelection(false);
        this.myOpenEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformationParametersPage.this.myData.setOpenResult(TransformationParametersPage.this.myOpenEditor.getSelection());
                TransformationParametersPage.this.performPageValidation();
            }
        });
        this.myOpenEditor.setLayoutData((Object)new GridData());
    }

    private void applyTargetUris(List<TargetUriData> paramTargetUris) {
        try {
            ILaunchConfigurationWorkingCopy workingCopy = QvtLaunchUtil.getInMemoryLaunchConfigurationType().newInstance(null, "QVTO");
            workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.elemCount", paramTargetUris.size());
            int index = 1;
            for (TargetUriData targetUri : paramTargetUris) {
                QvtLaunchUtil.saveTargetUriData((ILaunchConfigurationWorkingCopy)workingCopy, (TargetUriData)targetUri, (int)index);
                ++index;
            }
            this.myTransfSignatureControl.initializeFrom((ILaunchConfiguration)workingCopy);
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Fail to initialize luanch configuration", e);
        }
    }

    private List<TargetUriData> initTargetUriData() throws MdaException {
        URI firstUri = this.myInitialTargetUris.isEmpty() ? this.myTransformation.getURI() : this.myInitialTargetUris.get(0).getUri();
        IFile ifile = firstUri != null ? WorkspaceUtils.getWorkspaceFile((URI)firstUri) : null;
        List parameters = this.myTransformation.getParameters();
        ArrayList<TargetUriData> proposedUris = new ArrayList<TargetUriData>(parameters.size());
        int i = 0;
        while (i < parameters.size()) {
            if (this.myInitialTargetUris.size() > i) {
                proposedUris.add(this.myInitialTargetUris.get(i));
            } else {
                QvtTransformation.TransformationParameter transfParam = (QvtTransformation.TransformationParameter)parameters.get(i);
                if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN || transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
                    proposedUris.add(new TargetUriData(""));
                } else if (ifile == null) {
                    proposedUris.add(new TargetUriData(""));
                } else {
                    try {
                        String extension = transfParam.getMetamodels().isEmpty() ? "xmi" : ((EPackage)transfParam.getMetamodels().get(0)).getName();
                        String fileName = String.valueOf(this.myTransformation.getModuleName()) + "." + extension;
                        Path targetPath = new Path(ifile.getParent().getFullPath() + "/" + fileName);
                        URI targetUri = URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)false);
                        proposedUris.add(new TargetUriData(targetUri == null ? "" : targetUri.toString()));
                    }
                    catch (Exception e) {
                        proposedUris.add(new TargetUriData(""));
                    }
                }
            }
            ++i;
        }
        return proposedUris;
    }

    public void applyConfiguration(ILaunchConfigurationWorkingCopy workingCopy) {
        this.myTransfSignatureControl.performApply(workingCopy);
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", this.myTraceFile.getText());
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", this.myTraceFile.getUseFileFlag());
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", this.myTraceFile.isIncrementalUpdate());
        this.myData.setTraceFile(this.myTraceFile.getText());
        this.myData.setUseTraceFile(this.myTraceFile.getUseFileFlag());
        this.myData.setIncrementalUpdate(this.myTraceFile.isIncrementalUpdate());
    }

    private void performPageValidation() {
        if (!this.isSkipValidation) {
            this.setPageComplete(this.validatePage(QvtValidator.ValidationType.LIGHTWEIGHT_VALIDATION));
        }
    }

    protected boolean validatePage(QvtValidator.ValidationType validationType) {
        String moduleName;
        if (this.myTransformation == null) {
            return false;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        try {
            moduleName = this.myTransformation.getModuleName();
        }
        catch (MdaException e) {
            IStatus status = StatusUtil.makeErrorStatus((String)e.getMessage(), (Exception)((Object)e));
            return TransformationControls.statusToTab((IStatus)status, (ISetMessage)this.SET_MESSAGE);
        }
        if (this.myTraceFile.getText().length() == 0) {
            this.myTraceFile.update(moduleName, "qvtotrace");
        }
        IStatus status = this.myTransfSignatureControl.validate(moduleName, this.getShell(), this.myTraceFile.getText(), this.myTraceFile.getUseFileFlag(), this.myTraceFile.isIncrementalUpdate(), validationType);
        return TransformationControls.statusToTab((IStatus)status, (ISetMessage)this.SET_MESSAGE);
    }

    private String getTraceFileName() {
        URI uri = this.myTransfSignatureControl.getDefaultTraceName();
        return uri == null ? null : uri.toString();
    }

    private void initTraceFileText() {
        if (this.myTraceNameNonChanged || this.myTraceFile.getText().length() == 0) {
            boolean oldIsSkipValidation = this.isSkipValidation;
            this.isSkipValidation = true;
            String traceFileName = this.getTraceFileName();
            this.myTraceFile.setText(traceFileName);
            if (traceFileName != null) {
                IPath path = Path.fromOSString((String)traceFileName);
                this.myTraceFile.update(path.lastSegment().replaceAll(".qvtotrace", ""), "qvtotrace");
            }
            this.isSkipValidation = oldIsSkipValidation;
        }
    }
}

