/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.property.edit.properties;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jwt.we.conf.model.Aspect;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.aspects.AspectManager;
import org.eclipse.jwt.we.conf.property.model.aspects.PropertyAspectFactory;
import org.eclipse.jwt.we.conf.property.model.property.Property;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PropertyPropertyDescriptor
extends PropertyDescriptor {
    public PropertyPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
        super(object, itemPropertyDescriptor);
    }

    public ILabelProvider getLabelProvider() {
        final IItemLabelProvider itemLabelProvider = this.itemPropertyDescriptor.getLabelProvider(this.object);
        return new LabelProvider(){

            public String getText(Object value) {
                Property propertyObject = (Property)PropertyPropertyDescriptor.this.object;
                Aspect propertyAspect = AspectManager.INSTANCE.getAspect((AspectInstance)propertyObject);
                if (propertyAspect == null) {
                    return null;
                }
                EClassifier propertyETypeClassifier = propertyAspect.getAspectInstanceEType();
                if (!(propertyETypeClassifier instanceof EDataType)) {
                    return null;
                }
                EDataType eDataType = (EDataType)propertyETypeClassifier;
                if (value != null && !eDataType.isInstance(value)) {
                    Object oldValue = value;
                    value = PropertyAspectFactory.INSTANCE.createDefaultValue(eDataType, propertyAspect.getDefaultValue());
                    if (oldValue.equals(propertyObject.getValue())) {
                        propertyObject.setValue(value);
                    }
                }
                return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
            }

            public Image getImage(Object object) {
                return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage(object));
            }
        };
    }

    public CellEditor createPropertyEditor(Composite parent) {
        Object result = null;
        Property propertyObject = (Property)this.object;
        Aspect propertyAspect = AspectManager.INSTANCE.getAspect((AspectInstance)propertyObject);
        if (propertyAspect == null) {
            return null;
        }
        EClassifier propertyETypeClassifier = propertyAspect.getAspectInstanceEType();
        if (!(propertyETypeClassifier instanceof EDataType)) {
            return null;
        }
        final EDataType eDataType = (EDataType)propertyETypeClassifier;
        if (eDataType.isSerializable()) {
            if (this.itemPropertyDescriptor.isMany(this.object)) {
                final ILabelProvider editLabelProvider = this.getEditLabelProvider();
                result = new ExtendedDialogCellEditor(parent, editLabelProvider){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), editLabelProvider, PropertyPropertyDescriptor.this.object, (EClassifier)eDataType, (List)this.doGetValue(), PropertyPropertyDescriptor.this.getDisplayName(), null, PropertyPropertyDescriptor.this.itemPropertyDescriptor.isMultiLine(PropertyPropertyDescriptor.this.object), false);
                        dialog.open();
                        return dialog.getResult();
                    }
                };
            } else {
                result = eDataType.getInstanceClass() == Boolean.class || eDataType.getInstanceClass() == Boolean.TYPE ? new ExtendedComboBoxCellEditor(parent, Arrays.asList(Boolean.FALSE, Boolean.TRUE), this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object)) : this.createEDataTypeCellEditor(eDataType, parent);
            }
        } else {
            result = super.createPropertyEditor(parent);
        }
        return result;
    }
}

