/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.handlers.project.OpenProjectHandler;
import org.eclipse.jubula.client.ui.rcp.wizards.ProjectWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class NewProjectHandler
extends AbstractProjectHandler {
    private void openNewProjectWizard() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                final ProjectWizard projectWizard = new ProjectWizard();
                projectWizard.init(null, null);
                WizardDialog dialog = new WizardDialog(NewProjectHandler.this.getActiveShell(), (IWizard)projectWizard){

                    protected void finishPressed() {
                        String selectedToolkit = projectWizard.getProjectSettingWizardPage().getAutToolkit();
                        if (selectedToolkit == null) {
                            selectedToolkit = projectWizard.getProjectSettingWizardPage().getProjectToolkit();
                        }
                        super.finishPressed();
                    }
                };
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    IProjectPO project = GeneralStorage.getInstance().getProject();
                    OpenProjectHandler.OpenProjectOperation op = new OpenProjectHandler.OpenProjectOperation(project);
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    public Object executeImpl(ExecutionEvent event) {
        if (GeneralStorage.getInstance().getProject() != null && Plugin.getDefault().anyDirtyStar() && !Plugin.getDefault().showSaveEditorDialog(this.getActiveShell())) {
            return null;
        }
        this.openNewProjectWizard();
        return null;
    }
}

