/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.log.stream;

import java.io.Closeable;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventConsumer;
import org.osgi.util.pushstream.PushEventSource;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.tracker.ServiceTracker;

public class LogEntrySource
implements PushEventSource<LogEntry> {
    private final Set<PushEventConsumer<? super LogEntry>> consumers = new CopyOnWriteArraySet<PushEventConsumer<? super LogEntry>>();
    private final ServiceTracker<LogReaderService, AtomicReference<LogReaderService>> withHistory;
    private volatile PushStream<LogEntry> logStream;
    private final ReentrantLock historyLock = new ReentrantLock();

    public LogEntrySource(ServiceTracker<LogReaderService, AtomicReference<LogReaderService>> withHistory) {
        this.withHistory = withHistory;
    }

    public PushStream<LogEntry> getLogStream() {
        return this.logStream;
    }

    public void setLogStream(PushStream<LogEntry> logStream) {
        this.logStream = logStream;
    }

    public Closeable open(PushEventConsumer<? super LogEntry> aec) throws Exception {
        LinkedBlockingDeque<LogEntry> historyList = new LinkedBlockingDeque<LogEntry>();
        if (!this.consumers.add(aec)) {
            throw new IllegalStateException("Cannot add the same consumer multiple times");
        }
        if (this.withHistory != null) {
            this.historyLock.lock();
            try {
                AtomicReference readerRef = (AtomicReference)this.withHistory.getService();
                LogReaderService reader = (LogReaderService)readerRef.get();
                if (reader != null) {
                    Enumeration e = reader.getLog();
                    if (e != null) {
                        while (e.hasMoreElements()) {
                            historyList.add((LogEntry)e.nextElement());
                        }
                    }
                    if (historyList != null) {
                        while (!historyList.isEmpty()) {
                            LogEntry logEntry = (LogEntry)historyList.removeLast();
                            this.logged(logEntry);
                        }
                    }
                }
            }
            finally {
                this.historyLock.unlock();
            }
        }
        Closeable result = () -> {
            if (this.consumers.remove(aec)) {
                try {
                    aec.accept(PushEvent.close());
                }
                catch (Exception exception) {}
            }
        };
        return result;
    }

    public void logged(LogEntry entry) {
        if (this.withHistory != null) {
            this.historyLock.lock();
        }
        try {
            for (PushEventConsumer<? super LogEntry> consumer : this.consumers) {
                try {
                    long status = consumer.accept(PushEvent.data(entry));
                    if (status >= 0L) continue;
                    consumer.accept(PushEvent.close());
                }
                catch (Exception exception) {}
            }
        }
        finally {
            if (this.withHistory != null) {
                this.historyLock.unlock();
            }
        }
    }
}

