/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.SaveDialogBoundsSettingsDialog;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SharedElementsDialog
extends SaveDialogBoundsSettingsDialog {
    private TableViewer viewer;
    private final MPlaceholder placeholder;
    private final IModelResource resource;
    private final ModelEditor editor;
    private final Messages Messages;

    public SharedElementsDialog(Shell parentShell, ModelEditor editor, MPlaceholder placeholder, IModelResource resource, Messages Messages2) {
        super(parentShell);
        this.editor = editor;
        this.placeholder = placeholder;
        this.resource = resource;
        this.Messages = Messages2;
    }

    protected Control createDialogArea(Composite parent) {
        ArrayList<Object> list;
        Composite comp = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.Messages.SharedElementsDialog_ShellTitle);
        this.setTitle(this.Messages.SharedElementsDialog_Title);
        this.setMessage(this.Messages.SharedElementsDialog_Message);
        Composite container = new Composite(comp, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label l = new Label(container, 0);
        l.setText(this.Messages.SharedElementsDialog_Name);
        Text searchText = new Text(container, 2688);
        searchText.setLayoutData((Object)new GridData(768));
        l = new Label(container, 0);
        this.viewer = new TableViewer(container);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.addDoubleClickListener(event -> this.okPressed());
        if (this.resource.getRoot().get(0) instanceof MApplication) {
            list = new ArrayList<Object>();
            for (MWindow m : ((MApplication)this.resource.getRoot().get(0)).getChildren()) {
                list.addAll(SharedElementsDialog.filter(m.getSharedElements()));
            }
            this.viewer.setInput(list);
        } else if (this.resource.getRoot().get(0) instanceof MModelFragments) {
            list = new ArrayList();
            for (MModelFragment f : ((MModelFragments)this.resource.getRoot().get(0)).getFragments()) {
                if (!(f instanceof MStringModelFragment) || !((MStringModelFragment)f).getFeaturename().equals("sharedElements")) continue;
                list.addAll(SharedElementsDialog.filter(f.getElements()));
            }
            for (MModelFragment f : ((MModelFragments)this.resource.getRoot().get(0)).getImports()) {
                list.addAll(SharedElementsDialog.filter(Collections.singletonList(f)));
            }
            this.viewer.setInput(list);
        }
        PatternFilter filter = new PatternFilter(true){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        this.viewer.addFilter((ViewerFilter)filter);
        ControlFactory.attachFiltering(searchText, this.viewer, filter);
        return comp;
    }

    protected void okPressed() {
        if (!this.viewer.getSelection().isEmpty()) {
            IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
            Command cmd = SetCommand.create((EditingDomain)this.resource.getEditingDomain(), (Object)this.placeholder, (Object)AdvancedPackageImpl.Literals.PLACEHOLDER__REF, (Object)s.getFirstElement());
            if (cmd.canExecute()) {
                this.resource.getEditingDomain().getCommandStack().execute(cmd);
                super.okPressed();
            }
        }
    }

    private static <T> List<T> filter(List<T> o) {
        ArrayList<T> rv = new ArrayList<T>();
        for (T i : o) {
            if (!(i instanceof MPart) && !(i instanceof MPartSashContainer) && !(i instanceof MArea) && !(i instanceof MPartStack)) continue;
            rv.add(i);
        }
        return rv;
    }

    private class LabelProviderImpl
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private LabelProviderImpl() {
        }

        public void update(ViewerCell cell) {
            EObject o = (EObject)cell.getElement();
            StyledString string = new StyledString(this.getTypename(o));
            if (o instanceof MUILabel) {
                string.append(" - " + ((MUILabel)o).getLabel(), StyledString.DECORATIONS_STYLER);
            }
            MApplicationElement el = (MApplicationElement)o;
            string.append(" - " + el.getElementId(), StyledString.DECORATIONS_STYLER);
            cell.setText(string.getString());
            cell.setStyleRanges(string.getStyleRanges());
            cell.setImage(this.getImage(o));
        }

        public String getText(Object element) {
            EObject o = (EObject)element;
            MApplicationElement el = (MApplicationElement)o;
            if (el instanceof MUILabel) {
                MUILabel label = (MUILabel)el;
                return String.valueOf(this.getTypename(o)) + " - " + el.getElementId() + " - " + label.getLabel();
            }
            return String.valueOf(this.getTypename(o)) + " - " + el.getElementId() + " - ";
        }

        private String getTypename(EObject o) {
            AbstractComponentEditor editor = SharedElementsDialog.this.editor.getEditor(o.eClass());
            if (editor != null) {
                return editor.getLabel(o);
            }
            return o.eClass().getName();
        }

        public Image getImage(Object element) {
            AbstractComponentEditor editor = SharedElementsDialog.this.editor.getEditor(((EObject)element).eClass());
            if (editor != null) {
                return editor.getImage(element);
            }
            return null;
        }
    }
}

