/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.upc.ast;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTSynchronizationStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;

public class UPCASTSynchronizationStatement
extends ASTAttributeOwner
implements IUPCASTSynchronizationStatement {
    private int statmentKind;
    private IASTExpression barrierExpression;

    public UPCASTSynchronizationStatement() {
    }

    public UPCASTSynchronizationStatement(IASTExpression barrierExpression, int statmentKind) {
        this.setBarrierExpression(barrierExpression);
        this.statmentKind = statmentKind;
    }

    @Override
    public UPCASTSynchronizationStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public UPCASTSynchronizationStatement copy(IASTNode.CopyStyle style) {
        UPCASTSynchronizationStatement copy = new UPCASTSynchronizationStatement();
        copy.statmentKind = this.statmentKind;
        copy.setBarrierExpression(this.barrierExpression == null ? null : this.barrierExpression.copy(style));
        return (UPCASTSynchronizationStatement)this.copy(copy, style);
    }

    @Override
    public IASTExpression getBarrierExpression() {
        return this.barrierExpression;
    }

    @Override
    public int getStatementKind() {
        return this.statmentKind;
    }

    @Override
    public void setBarrierExpression(IASTExpression expr) {
        this.barrierExpression = expr;
        if (expr != null) {
            expr.setParent((IASTNode)this);
            expr.setPropertyInParent(BARRIER_EXPRESSION);
        }
    }

    @Override
    public void setStatementKind(int kind) {
        this.statmentKind = kind;
    }

    public boolean accept(ASTVisitor visitor) {
        if (visitor.shouldVisitStatements) {
            switch (visitor.visit((IASTStatement)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(visitor)) {
            return false;
        }
        if (this.barrierExpression != null && !this.barrierExpression.accept(visitor)) {
            return false;
        }
        if (visitor.shouldVisitStatements) {
            switch (visitor.leave((IASTStatement)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

