/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ItemKind implements Enumerator
{
    PHYSICAL(0, "Physical", "Physical"),
    INFORMATION(1, "Information", "Information");

    public static final int PHYSICAL_VALUE = 0;
    public static final int INFORMATION_VALUE = 1;
    private static final ItemKind[] VALUES_ARRAY;
    public static final List<ItemKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ItemKind[]{PHYSICAL, INFORMATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ItemKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ItemKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ItemKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ItemKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ItemKind get(int value) {
        switch (value) {
            case 0: {
                return PHYSICAL;
            }
            case 1: {
                return INFORMATION;
            }
        }
        return null;
    }

    private ItemKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

