/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.LineBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementNonResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.GuiExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemBuilderUI;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemFigureProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class ExtendedEditPart
extends ReportElementEditPart {
    private IReportItemFigureProvider elementUI;

    public ExtendedEditPart(ExtendedItemHandle model) {
        super(model);
    }

    public void elementChanged(DesignElementHandle arg0, NotificationEvent arg1) {
        this.markDirty(true);
        this.refresh();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy(){

            public boolean understandsRequest(Request request) {
                if ("direct edit".equals(request.getType()) || "open".equals(request.getType())) {
                    return true;
                }
                return super.understandsRequest(request);
            }
        });
    }

    @Override
    public void refreshFigure() {
        this.refreshBorder((DesignElementHandle)this.getModel(), new LineBorder());
        this.getExtendedElementUI().updateFigure(this.getExtendedItemHandle(), this.getFigure());
        ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), this.getConstraint());
    }

    protected Object getConstraint() {
        ExtendedItemHandle handle = this.getExtendedItemHandle();
        ReportItemConstraint constraint = new ReportItemConstraint();
        String type = handle.getPrivateStyle().getDisplay();
        if (type == null || "none".equals(type)) {
            type = "block";
        }
        constraint.setDisplay(type);
        constraint.setMargin(this.getModelAdapter().getMargin(null));
        DimensionHandle value = handle.getWidth();
        constraint.setMeasure(value.getMeasure());
        constraint.setUnits(value.getUnits());
        String vAlign = handle.getPrivateStyle().getVerticalAlign();
        if ("middle".equals(vAlign)) {
            constraint.setAlign(0);
        } else if ("bottom".equals(vAlign)) {
            constraint.setAlign(2);
        } else if ("top".equals(vAlign)) {
            constraint.setAlign(1);
        }
        return constraint;
    }

    protected IFigure createFigure() {
        return this.getExtendedElementUI().createFigure(this.getExtendedItemHandle());
    }

    @Override
    public void performDirectEdit() {
        ExtendedElementUIPoint point = ExtensionPointManager.getInstance().getExtendedElementPoint(((ExtendedItemHandle)this.getModel()).getExtensionName());
        IReportItemBuilderUI builder = point.getReportItemBuilderUI();
        if (builder != null) {
            String displayLabel = (String)point.getAttribute("reportItemLabelUI");
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            String transName = Messages.getFormattedString((String)"ExtendedEditPart.edit", (Object[])new Object[]{displayLabel == null ? DEUtil.getMetaDataDictionary().getExtension(point.getExtensionName()).getDisplayName() : displayLabel});
            stack.startTrans(transName);
            int result = 1;
            try {
                result = builder.open(this.getExtendedItemHandle());
            }
            catch (RuntimeException e) {
                ExceptionHandler.handle(e);
                stack.rollback();
                return;
            }
            if (result == 0) {
                stack.commit();
                this.refreshVisuals();
            } else {
                stack.rollback();
            }
        }
    }

    public IReportItemFigureProvider getExtendedElementUI() {
        return this.elementUI;
    }

    public void setExtendedElementUI(IReportItemFigureProvider elementUI) {
        this.elementUI = elementUI;
    }

    public ExtendedItemHandle getExtendedItemHandle() {
        return (ExtendedItemHandle)this.getModel();
    }

    public boolean canResize() {
        String id = GuiExtensionManager.getExtendedElementID(this.getExtendedItemHandle());
        Boolean bool = (Boolean)ExtensionPointManager.getInstance().getExtendedElementPoint(id).getAttribute("canResize");
        return bool;
    }

    @Override
    public void deactivate() {
        this.elementUI.disposeFigure(this.getExtendedItemHandle(), this.getFigure());
        super.deactivate();
    }

    @Override
    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        if (this.canResize()) {
            return super.getResizePolice(parentPolice);
        }
        return new ReportElementNonResizablePolicy();
    }

    @Override
    protected void updateLayoutPreference() {
        super.updateLayoutPreference();
        if (this.getFigure() instanceof LabelFigure) {
            ((LabelFigure)this.getFigure()).setFixLayout(this.isFixLayout());
        }
    }
}

