/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONStructure;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.core.document.JSONException;
import org.eclipse.wst.json.core.internal.document.JSONObjectImpl;
import org.eclipse.wst.json.core.internal.document.JSONStructureImpl;
import org.eclipse.wst.json.core.internal.document.JSONValueImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class JSONPairImpl
extends JSONStructureImpl
implements IJSONPair {
    private String name;
    private ITextRegion nameRegion = null;
    private ITextRegion equalRegion = null;
    private JSONObjectImpl ownerObject = null;
    private IJSONValue value;

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        name = name.substring(1, name.length() - 1);
        String oldName = this.name;
        this.name = name;
        this.notify(1, this, oldName, name, this.getStartOffset());
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public String getNodeValue() throws JSONException {
        return null;
    }

    @Override
    public IJSONNode cloneNode(boolean deep) {
        return null;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    public void setOwnerObject(JSONObjectImpl ownerObject) {
        this.ownerObject = ownerObject;
    }

    @Override
    public JSONObjectImpl getOwnerObject() {
        return this.ownerObject;
    }

    @Override
    public IJSONValue getValue() {
        return this.value;
    }

    public void setNameRegion(ITextRegion nameRegion) {
        this.nameRegion = nameRegion;
    }

    @Override
    public ITextRegion getNameRegion() {
        return this.nameRegion;
    }

    @Override
    public int getStartOffset() {
        if (this.getStartStructuredDocumentRegion() == null) {
            return 0;
        }
        int offset = this.getStartStructuredDocumentRegion().getStartOffset();
        return offset;
    }

    @Override
    public int getEndOffset() {
        if (this.getStartStructuredDocumentRegion() == null) {
            return 0;
        }
        int offset = this.getStartStructuredDocumentRegion().getEndOffset();
        if (this.value != null) {
            return this.value.getEndOffset();
        }
        return offset;
    }

    public void setEqualRegion(ITextRegion equalRegion) {
        this.equalRegion = equalRegion;
    }

    @Override
    public short getNodeValueType() {
        if (this.value != null) {
            return this.value.getNodeType();
        }
        return -1;
    }

    @Override
    public String getSimpleValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.getSimpleValue();
    }

    @Override
    public String getValueRegionType() {
        if (this.value != null) {
            if (this.value.getStartStructuredDocumentRegion() == null) {
                return null;
            }
            return this.value.getStartStructuredDocumentRegion().getType();
        }
        return null;
    }

    public void setValue(IJSONValue value) {
        ((JSONValueImpl)value).setParentNode(this.ownerObject);
        ((JSONValueImpl)value).setOwnerPairNode(this);
        this.value = value;
        this.notify(1, this, null, this.value, this.getStartOffset());
    }

    public void updateValue(IJSONValue value) {
        IJSONValue oldValue = this.value;
        ((JSONValueImpl)value).setParentNode(this.ownerObject);
        ((JSONValueImpl)value).setOwnerPairNode(this);
        this.value = value;
        this.notify(1, null, oldValue, this.value, this.getStartOffset());
    }

    @Override
    public IStructuredDocumentRegion getEndStructuredDocumentRegion() {
        if (this.value != null) {
            return ((IJSONStructure)this.value).getStartStructuredDocumentRegion();
        }
        return super.getEndStructuredDocumentRegion();
    }

    public String toString() {
        IStructuredDocumentRegion endStructuredDocumentRegion;
        StringBuilder buffer = new StringBuilder();
        String tagName = this.getName();
        buffer.append(tagName);
        IStructuredDocumentRegion startStructuredDocumentRegion = this.getStartStructuredDocumentRegion();
        if (startStructuredDocumentRegion != null) {
            buffer.append('@');
            buffer.append(startStructuredDocumentRegion.toString());
        }
        if ((endStructuredDocumentRegion = this.getEndStructuredDocumentRegion()) != null) {
            buffer.append('@');
            buffer.append(endStructuredDocumentRegion.toString());
        }
        return buffer.toString();
    }
}

