/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.google.common.collect.Lists;
import com.jgoodies.forms.layout.CellConstraints;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swing.FormLayout.Activator;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

public class SelectionActionsSupport
extends ObjectEventListener {
    private final FormLayoutInfo m_layout;

    public SelectionActionsSupport(FormLayoutInfo layout) {
        this.m_layout = layout;
        this.m_layout.addBroadcastListener((Object)this);
    }

    public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList constraints = Lists.newArrayList();
        for (ObjectInfo object : objects) {
            if (!(object instanceof ComponentInfo) || object.getParent() != this.m_layout.getContainer()) {
                return;
            }
            ComponentInfo component = (ComponentInfo)object;
            constraints.add(FormLayoutInfo.getConstraints(component));
        }
        actions.add(new Separator());
        this.addAlignmentAction(actions, constraints, true, "default.gif", ModelMessages.SelectionActionsSupport_haDefault, CellConstraints.DEFAULT);
        this.addAlignmentAction(actions, constraints, true, "left.gif", ModelMessages.SelectionActionsSupport_haLeft, CellConstraints.LEFT);
        this.addAlignmentAction(actions, constraints, true, "center.gif", ModelMessages.SelectionActionsSupport_haCenter, CellConstraints.CENTER);
        this.addAlignmentAction(actions, constraints, true, "right.gif", ModelMessages.SelectionActionsSupport_haRight, CellConstraints.RIGHT);
        this.addAlignmentAction(actions, constraints, true, "fill.gif", ModelMessages.SelectionActionsSupport_haFill, CellConstraints.FILL);
        actions.add(new Separator());
        this.addAlignmentAction(actions, constraints, false, "default.gif", ModelMessages.SelectionActionsSupport_vaDefault, CellConstraints.DEFAULT);
        this.addAlignmentAction(actions, constraints, false, "top.gif", ModelMessages.SelectionActionsSupport_haTop, CellConstraints.TOP);
        this.addAlignmentAction(actions, constraints, false, "center.gif", ModelMessages.SelectionActionsSupport_vaCenter, CellConstraints.CENTER);
        this.addAlignmentAction(actions, constraints, false, "bottom.gif", ModelMessages.SelectionActionsSupport_vaBottom, CellConstraints.BOTTOM);
        this.addAlignmentAction(actions, constraints, false, "fill.gif", ModelMessages.SelectionActionsSupport_vaFill, CellConstraints.FILL);
    }

    private void addAlignmentAction(List<Object> actions, List<CellConstraintsSupport> constraints, boolean horizontal, String iconPath, String tooltip, CellConstraints.Alignment alignment) {
        boolean isChecked = true;
        for (CellConstraintsSupport constraint : constraints) {
            if (horizontal) {
                if (constraint.alignH == alignment) continue;
                isChecked = false;
                break;
            }
            if (constraint.alignV == alignment) continue;
            isChecked = false;
            break;
        }
        AlignmentAction action = new AlignmentAction(constraints, horizontal, iconPath, tooltip, isChecked, alignment);
        actions.add((Object)action);
    }

    private abstract class AbstractAction
    extends ObjectInfoAction {
        private final List<CellConstraintsSupport> m_constraints;
        private final boolean m_horizontal;

        public AbstractAction(int style, List<CellConstraintsSupport> constraints, boolean horizontal, String iconPath, String tooltip, boolean checked) {
            super((ObjectInfo)SelectionActionsSupport.this.m_layout, "", style);
            this.m_constraints = constraints;
            this.m_horizontal = horizontal;
            String path = "alignment/" + (this.m_horizontal ? "h" : "v") + "/menu/" + iconPath;
            this.setImageDescriptor(Activator.getImageDescriptor(path));
            this.setToolTipText(tooltip);
            this.setChecked(checked);
        }

        protected void runEx() throws Exception {
            for (CellConstraintsSupport constraint : this.m_constraints) {
                if (this.m_horizontal) {
                    this.handleHorizontal(constraint);
                } else {
                    this.handleVertical(constraint);
                }
                constraint.write();
            }
        }

        protected abstract void handleHorizontal(CellConstraintsSupport var1) throws Exception;

        protected abstract void handleVertical(CellConstraintsSupport var1) throws Exception;
    }

    private final class AlignmentAction
    extends AbstractAction {
        private final CellConstraints.Alignment m_alignment;

        public AlignmentAction(List<CellConstraintsSupport> constraints, boolean horizontal, String iconPath, String tooltip, boolean checked, CellConstraints.Alignment alignment) {
            super(8, constraints, horizontal, iconPath, tooltip, checked);
            this.m_alignment = alignment;
        }

        @Override
        protected void handleHorizontal(CellConstraintsSupport constraint) throws Exception {
            constraint.alignH = this.m_alignment;
        }

        @Override
        protected void handleVertical(CellConstraintsSupport constraint) throws Exception {
            constraint.alignV = this.m_alignment;
        }
    }
}

