/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.view;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public abstract class AbstractRegistryView
implements IRegistryView {
    private static final String LISTENER_EXCEPTION_REMOVE = "Exception occurred while notifying view listener %s about entry removal";
    private static final String LISTENER_EXCEPTION_ADD = "Exception occurred while notifying view listener %s about entry addition";
    protected final IQuerySpecificationRegistry registry;
    protected final SetMultimap<String, IQuerySpecificationRegistryEntry> fqnToEntryMap;
    protected final Set<IQuerySpecificationRegistryChangeListener> listeners;
    protected final boolean allowDuplicateFQNs;

    protected abstract boolean isEntryRelevant(IQuerySpecificationRegistryEntry var1);

    public AbstractRegistryView(IQuerySpecificationRegistry registry, boolean allowDuplicateFQNs) {
        this.registry = registry;
        this.allowDuplicateFQNs = allowDuplicateFQNs;
        this.fqnToEntryMap = Multimaps.newSetMultimap(new TreeMap(), HashSet::new);
        this.listeners = new HashSet<IQuerySpecificationRegistryChangeListener>();
    }

    @Override
    public IQuerySpecificationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Iterable<IQuerySpecificationRegistryEntry> getEntries() {
        return Collections.unmodifiableSet(new HashSet(this.fqnToEntryMap.values()));
    }

    @Override
    public Set<String> getQuerySpecificationFQNs() {
        return Collections.unmodifiableSet(new HashSet(this.fqnToEntryMap.keySet()));
    }

    @Override
    public boolean hasQuerySpecificationFQN(String fullyQualifiedName) {
        Preconditions.checkArgument((fullyQualifiedName != null ? 1 : 0) != 0, (String)"FQN must not be null!");
        return this.fqnToEntryMap.containsKey((Object)fullyQualifiedName);
    }

    @Override
    public Set<IQuerySpecificationRegistryEntry> getEntries(String fullyQualifiedName) {
        Preconditions.checkArgument((fullyQualifiedName != null ? 1 : 0) != 0, (String)"FQN must not be null!");
        Set entries = this.fqnToEntryMap.get((Object)fullyQualifiedName);
        return Collections.unmodifiableSet(new HashSet(entries));
    }

    @Override
    public void addViewListener(IQuerySpecificationRegistryChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Null listener not supported");
        this.listeners.add(listener);
    }

    @Override
    public void removeViewListener(IQuerySpecificationRegistryChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Null listener not supported");
        this.listeners.remove(listener);
    }

    @Override
    public void entryAdded(IQuerySpecificationRegistryEntry entry) {
        if (this.isEntryRelevant(entry)) {
            String fullyQualifiedName = entry.getFullyQualifiedName();
            if (!this.allowDuplicateFQNs && this.fqnToEntryMap.containsKey((Object)fullyQualifiedName)) {
                Set removed = this.fqnToEntryMap.removeAll((Object)fullyQualifiedName);
                for (IQuerySpecificationRegistryEntry e : removed) {
                    this.notifyListeners(e, false);
                }
            }
            this.fqnToEntryMap.put((Object)fullyQualifiedName, (Object)entry);
            this.notifyListeners(entry, true);
        }
    }

    @Override
    public void entryRemoved(IQuerySpecificationRegistryEntry entry) {
        if (this.isEntryRelevant(entry)) {
            String fullyQualifiedName = entry.getFullyQualifiedName();
            this.fqnToEntryMap.remove((Object)fullyQualifiedName, (Object)entry);
            this.notifyListeners(entry, false);
        }
    }

    private void notifyListeners(IQuerySpecificationRegistryEntry entry, boolean addition) {
        for (IQuerySpecificationRegistryChangeListener listener : this.listeners) {
            try {
                if (addition) {
                    listener.entryAdded(entry);
                    continue;
                }
                listener.entryRemoved(entry);
            }
            catch (Exception ex) {
                Logger logger = ViatraQueryLoggingUtil.getLogger(AbstractRegistryView.class);
                String formatString = addition ? LISTENER_EXCEPTION_ADD : LISTENER_EXCEPTION_REMOVE;
                logger.error((Object)String.format(formatString, listener), (Throwable)ex);
            }
        }
    }
}

