/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.pcap;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2.EthernetIIPacket;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;

public class PcapPacket
extends Packet {
    private static final int TIMESTAMP_MICROSECOND_MAX = 1000000;
    private static final int TIMESTAMP_NANOSECOND_MAX = 1000000000;
    private final @Nullable Packet fChildPacket;
    private final @Nullable ByteBuffer fPayload;
    private final long fTimestamp;
    private final long fIncludedLength;
    private final long fOriginalLength;
    private final long fPacketIndex;
    private @Nullable PcapEndpoint fSourceEndpoint;
    private @Nullable PcapEndpoint fDestinationEndpoint;
    private @Nullable Map<String, String> fFields;

    public PcapPacket(PcapFile file, @Nullable Packet parent, ByteBuffer header, @Nullable ByteBuffer payload, long index) throws BadPacketException {
        super(file, parent, PcapProtocol.PCAP);
        if (header.array().length < 16) {
            this.fChildPacket = null;
            throw new BadPacketException("The Pcap packet header is too small.");
        }
        this.fSourceEndpoint = null;
        this.fDestinationEndpoint = null;
        this.fFields = null;
        this.fPacketIndex = index;
        header.order(this.getPcapFile().getByteOrder());
        header.position(0);
        long timestampMostSignificant = ConversionHelper.unsignedIntToLong(header.getInt());
        long timestampLeastSignificant = ConversionHelper.unsignedIntToLong(header.getInt());
        switch (this.getTimestampScale()) {
            case MICROSECOND: {
                if (timestampLeastSignificant > 1000000L) {
                    this.fChildPacket = null;
                    throw new BadPacketException("The timestamp is erroneous.");
                }
                this.fTimestamp = 1000000L * timestampMostSignificant + timestampLeastSignificant;
                break;
            }
            case NANOSECOND: {
                if (timestampLeastSignificant > 1000000000L) {
                    this.fChildPacket = null;
                    throw new BadPacketException("The timestamp is erroneous.");
                }
                this.fTimestamp = 1000000000L * timestampMostSignificant + timestampLeastSignificant;
                break;
            }
            default: {
                throw new IllegalArgumentException("The timestamp precision is not valid!");
            }
        }
        this.fIncludedLength = ConversionHelper.unsignedIntToLong(header.getInt());
        this.fOriginalLength = ConversionHelper.unsignedIntToLong(header.getInt());
        ByteBuffer pcapPacket = payload;
        if (pcapPacket == null) {
            this.fChildPacket = null;
            this.fPayload = null;
            return;
        }
        pcapPacket.order(ByteOrder.BIG_ENDIAN);
        pcapPacket.position(0);
        this.fPayload = pcapPacket;
        this.fChildPacket = this.findChildPacket();
    }

    @Override
    public @Nullable Packet getChildPacket() {
        return this.fChildPacket;
    }

    @Override
    public @Nullable ByteBuffer getPayload() {
        return this.fPayload;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public long getIncludedLength() {
        return this.fIncludedLength;
    }

    public long getOriginalLength() {
        return this.fOriginalLength;
    }

    public boolean isTruncated() {
        return this.fIncludedLength != this.fOriginalLength;
    }

    public long getIndex() {
        return this.fPacketIndex;
    }

    public String toString() {
        String string = String.valueOf(this.getProtocol().getName()) + " " + this.fPacketIndex + ": " + this.fOriginalLength + " bytes on wire, " + this.fIncludedLength + " bytes captured.\nArrival time: " + ConversionHelper.toGMTTime(this.fTimestamp, this.getTimestampScale()) + "\n";
        Packet child = this.fChildPacket;
        if (child != null) {
            return String.valueOf(string) + child.toString();
        }
        return string;
    }

    @Override
    protected @Nullable Packet findChildPacket() throws BadPacketException {
        @Nullable ByteBuffer payload = this.fPayload;
        if (payload == null) {
            return null;
        }
        switch ((int)this.getPcapFile().getDataLinkType()) {
            case 1: {
                return new EthernetIIPacket(this.getPcapFile(), (Packet)this, payload);
            }
        }
        return new UnknownPacket(this.getPcapFile(), (Packet)this, payload);
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public PcapEndpoint getSourceEndpoint() {
        PcapEndpoint endpoint = this.fSourceEndpoint;
        if (endpoint == null) {
            endpoint = new PcapEndpoint(this, true);
        }
        this.fSourceEndpoint = endpoint;
        return this.fSourceEndpoint;
    }

    @Override
    public PcapEndpoint getDestinationEndpoint() {
        PcapEndpoint endpoint = this.fDestinationEndpoint;
        if (endpoint == null) {
            endpoint = new PcapEndpoint(this, false);
        }
        this.fDestinationEndpoint = endpoint;
        return this.fDestinationEndpoint;
    }

    @Override
    public Map<String, String> getFields() {
        Map<String, String> map = this.fFields;
        if (map == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"Frame", (Object)String.valueOf(this.fPacketIndex));
            builder.put((Object)"Frame Length", (Object)(String.valueOf(String.valueOf(this.fOriginalLength)) + " bytes"));
            builder.put((Object)"Capture Length", (Object)(String.valueOf(String.valueOf(this.fIncludedLength)) + " bytes"));
            builder.put((Object)"Capture Time", (Object)ConversionHelper.toGMTTime(this.fTimestamp, this.getTimestampScale()));
            this.fFields = builder.build();
            return this.fFields;
        }
        return map;
    }

    @Override
    public String getLocalSummaryString() {
        return "Frame " + this.fPacketIndex + ": " + this.fOriginalLength + " bytes on wire, " + this.fIncludedLength + " bytes captured";
    }

    @Override
    protected String getSignificationString() {
        return "New Frame: " + this.fOriginalLength + " bytes on wire";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        Packet child = this.fChildPacket;
        result = child == null ? (result *= 31) : 31 * result + child.hashCode();
        result = 31 * result + (int)(this.fIncludedLength ^ this.fIncludedLength >>> 32);
        result = 31 * result + (int)(this.fOriginalLength ^ this.fOriginalLength >>> 32);
        result = 31 * result + (int)(this.fPacketIndex ^ this.fPacketIndex >>> 32);
        ByteBuffer payload = this.fPayload;
        result = payload == null ? (result *= 31) : 31 * result + payload.hashCode();
        result = 31 * result + (int)(this.fTimestamp ^ this.fTimestamp >>> 32);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PcapPacket other = (PcapPacket)obj;
        if (!Objects.equals(this.fChildPacket, other.fChildPacket)) {
            return false;
        }
        if (this.fIncludedLength != other.fIncludedLength) {
            return false;
        }
        if (this.fOriginalLength != other.fOriginalLength) {
            return false;
        }
        if (this.fPacketIndex != other.fPacketIndex) {
            return false;
        }
        if (!Objects.equals(this.fPayload, other.fPayload)) {
            return false;
        }
        return this.fTimestamp == other.fTimestamp;
    }

    public PcapTimestampScale getTimestampScale() {
        return this.getPcapFile().getTimestampPrecision();
    }
}

