/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal.adapters;

import java.io.File;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.adapters.ModelNodePersistableURIProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.locator.model.ModelLocationUtil;
import org.osgi.framework.Version;

public class PeerPersistableURIProvider
extends ModelNodePersistableURIProvider {
    private IPeer getPeer(Object context) {
        IPeer peer = null;
        if (context instanceof IPeer) {
            peer = (IPeer)context;
        } else if (context instanceof IPeerNode) {
            peer = ((IPeerNode)context).getPeer();
        } else if (context instanceof IPeerNodeProvider) {
            peer = ((IPeerNodeProvider)context).getPeerNode().getPeer();
        }
        return peer;
    }

    public URI getURI(Object context) {
        Assert.isNotNull((Object)context);
        URI uri = null;
        final IPeer peer = this.getPeer(context);
        if (peer != null) {
            final AtomicReference nodeURI = new AtomicReference();
            final AtomicReference version = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String value = (String)peer.getAttributes().get("URI.transient");
                    if (value != null && !"".equals(value.trim())) {
                        nodeURI.set(URI.create(value.trim()));
                    }
                    version.set((value = (String)peer.getAttributes().get("Version")) != null ? new Version(value.trim()) : null);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            if (nodeURI.get() != null) {
                uri = (URI)nodeURI.get();
            }
            if (uri == null) {
                String baseName = peer.getName();
                if (baseName == null) {
                    baseName = peer.getID();
                }
                String name = this.makeValidFileSystemName(baseName);
                uri = this.getRoot().append(String.valueOf(name) + ".peer").toFile().toURI();
                try {
                    File file = new File(uri.normalize());
                    int i = 0;
                    while (file.exists()) {
                        name = this.makeValidFileSystemName(String.valueOf(baseName) + (version.get() != null ? "_" + ((Version)version.get()).toString() : "") + (i > 0 ? " (" + i + ")" : ""));
                        uri = this.getRoot().append(String.valueOf(name) + ".peer").toFile().toURI();
                        file = new File(uri.normalize());
                        ++i;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return uri;
    }

    public IPath getRoot() {
        return ModelLocationUtil.getStaticPeersRootLocation();
    }
}

