/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.copy;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.dialect.command.CopyRepresentationCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.dialog.RenameDialog;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CopyRepresentationAction
extends Action {
    final Session session;
    final Collection<DRepresentationDescriptor> repDescriptors;

    public CopyRepresentationAction(Session session, Collection<DRepresentationDescriptor> selection) {
        super(Messages.CopyRepresentationAction_name);
        this.session = session;
        this.repDescriptors = selection;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        if (!this.isValidSelection()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        RenameDialog dialog;
        if (this.repDescriptors.size() == 1) {
            String oldName = this.getOldName();
            dialog = new RenameDialog(Display.getCurrent().getActiveShell(), oldName);
            dialog.setTitle(Messages.CopyRepresentationAction_copyRepresentationDialog_title);
            dialog.create();
        } else {
            String prefix = this.getPrefix();
            dialog = new RenameDialog(Display.getCurrent().getActiveShell(), prefix);
            dialog.setTitle(Messages.CopyRepresentationAction_copyRepresentationsDialog_title);
            dialog.setMessage(Messages.CopyRepresentationAction_copyRepresentationsDialog_message);
            dialog.setDefaultNewName(Messages.CopyRepresentationAction_copyRepresentationsDialog_defaultNewName);
            dialog.create();
        }
        if (dialog.open() == 0) {
            String newName = dialog.getNewName();
            DRepresentationDescriptor dRepDescriptor = this.repDescriptors.iterator().next();
            TransactionalEditingDomain transDomain = TransactionUtil.getEditingDomain((EObject)dRepDescriptor);
            ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
            for (DRepresentationDescriptor dRepresentationDescriptor : this.repDescriptors) {
                representations.add(dRepresentationDescriptor.getRepresentation());
            }
            transDomain.getCommandStack().execute((Command)new CopyRepresentationCommand(transDomain, representations, newName, this.session));
        }
    }

    private String getOldName() {
        DRepresentationDescriptor dRepDescriptor = this.repDescriptors.iterator().next();
        return dRepDescriptor.getName() != null ? dRepDescriptor.getName() : "";
    }

    private String getPrefix() {
        return "";
    }

    private boolean isValidSelection() {
        boolean anyInvalidCopy = Iterables.any(this.repDescriptors, (Predicate)new Predicate<DRepresentationDescriptor>(){

            public boolean apply(DRepresentationDescriptor input) {
                IPermissionAuthority permissionAuthority;
                EObject container = input.eContainer();
                return container instanceof DView && (permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(container)) != null && !permissionAuthority.canCreateIn(container);
            }
        });
        return !anyInvalidCopy;
    }
}

