/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.dialect.description;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramComponentizationHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.DiagramImportDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.diagram.description.OrderedTreeLayout;
import org.eclipse.sirius.diagram.description.util.DescriptionSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class DiagramInterpretedExpressionTargetSwitch
extends DescriptionSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected EStructuralFeature feature;
    protected boolean considerFeature;
    protected IInterpretedExpressionTargetSwitch globalSwitch;

    public DiagramInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch theGlobalSwitch) {
        this.feature = feature;
        this.globalSwitch = theGlobalSwitch;
    }

    @Override
    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        LinkedHashSet defaultResult = new LinkedHashSet();
        return Options.newSome(defaultResult);
    }

    public void setConsiderFeature(boolean considerFeature) {
        this.considerFeature = considerFeature;
    }

    private int getFeatureId(EClass eClass) {
        int featureID = -1;
        if (this.considerFeature && this.feature != null) {
            featureID = eClass.getFeatureID(this.feature);
        }
        return featureID;
    }

    private EObject getFirstRelevantContainer(EObject element) {
        return this.globalSwitch.getFirstRelevantContainer(element);
    }

    @Override
    public Option<Collection<String>> caseDiagramDescription(DiagramDescription diagramDescription) {
        Option result = null;
        LinkedHashSet<String> target = new LinkedHashSet<String>();
        switch (this.getFeatureId(diagramDescription.eClass())) {
            case -1: 
            case 5: 
            case 18: 
            case 20: {
                target.add(diagramDescription.getDomainClass());
                result = Options.newSome(target);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseDiagramExtensionDescription(DiagramExtensionDescription object) {
        DiagramDescription diagramDescription = DiagramComponentizationHelper.getDiagramDescription(object, ViewpointRegistry.getInstance().getViewpoints());
        if (diagramDescription != null) {
            return this.doSwitch(diagramDescription);
        }
        return null;
    }

    @Override
    public Option<Collection<String>> caseDiagramImportDescription(DiagramImportDescription object) {
        Option result = null;
        LinkedHashSet<String> target = new LinkedHashSet<String>();
        switch (this.getFeatureId(object.eClass())) {
            case -1: 
            case 4: {
                target.add(object.getDomainClass());
                result = Options.newSome(target);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseMappingBasedDecoration(MappingBasedDecoration object) {
        Option result = null;
        LinkedHashSet target = new LinkedHashSet();
        switch (this.getFeatureId(object.eClass())) {
            case -1: 
            case 3: 
            case 4: 
            case 5: {
                for (DiagramElementMapping mapping : object.getMappings()) {
                    Option mappingTargets = this.globalSwitch.doSwitch((EObject)mapping, false);
                    if (!mappingTargets.some()) continue;
                    target.addAll((Collection)mappingTargets.get());
                }
                result = Options.newSome(target);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseAbstractNodeMapping(AbstractNodeMapping object) {
        Option result = null;
        LinkedHashSet<String> target = new LinkedHashSet<String>();
        switch (this.getFeatureId(object.eClass())) {
            case 8: {
                result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
                break;
            }
            case -1: 
            case 5: 
            case 10: {
                target.add(object.getDomainClass());
                result = Options.newSome(target);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseEdgeMapping(EdgeMapping edgeMapping) {
        Option result = null;
        LinkedHashSet<String> target = new LinkedHashSet<String>();
        if (edgeMapping.isUseDomainElement()) {
            switch (this.getFeatureId(edgeMapping.eClass())) {
                case 8: {
                    result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer(edgeMapping), false);
                    break;
                }
                case -1: 
                case 5: 
                case 10: 
                case 16: 
                case 17: 
                case 20: 
                case 24: {
                    target.add(edgeMapping.getDomainClass());
                    result = Options.newSome(target);
                    break;
                }
            }
        } else {
            switch (this.getFeatureId(edgeMapping.eClass())) {
                case 8: 
                case 17: {
                    result = Options.newNone();
                    break;
                }
                case -1: 
                case 5: 
                case 10: 
                case 16: 
                case 20: 
                case 24: {
                    for (DiagramElementMapping mapping : edgeMapping.getSourceMapping()) {
                        Option sourceMappingTarget;
                        if (mapping.equals(edgeMapping) || !(sourceMappingTarget = this.globalSwitch.doSwitch((EObject)mapping, false)).some()) continue;
                        target.addAll((Collection)sourceMappingTarget.get());
                    }
                    result = Options.newSome(target);
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseEdgeMappingImport(EdgeMappingImport object) {
        IEdgeMappingQuery edgeMappingQuery = new IEdgeMappingQuery(object);
        Option<EdgeMapping> option = edgeMappingQuery.getOriginalEdgeMapping();
        if (option.some()) {
            return this.doSwitch((EObject)option.get());
        }
        return null;
    }

    @Override
    public Option<Collection<String>> caseOrderedTreeLayout(OrderedTreeLayout layout) {
        LinkedHashSet target = new LinkedHashSet();
        Option result = Options.newSome(target);
        switch (this.getFeatureId(DescriptionPackage.eINSTANCE.getOrderedTreeLayout())) {
            case 1: {
                result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)layout), false);
                break;
            }
        }
        return result;
    }
}

