/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.util.SiriusCopier;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.layoutdata.AbstractLayoutData;
import org.eclipse.sirius.diagram.layoutdata.EdgeLayoutData;
import org.eclipse.sirius.diagram.layoutdata.LayoutdataFactory;
import org.eclipse.sirius.diagram.layoutdata.NodeLayoutData;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutDataHelper;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.semantic.AbstractSemanticLayoutDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.semantic.SemanticEdgeLayoutDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.semantic.SemanticNodeLayoutDataKey;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.Style;

public class LayoutDataHelperImpl
implements LayoutDataHelper {
    private static final Predicate<EObject> ROOT_PREDICATE = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            return input.eContainer() == null;
        }
    };

    @Override
    public NodeLayoutData createNodeLayoutData(Node node, IGraphicalEditPart editPart, NodeLayoutData parentLayoutData) {
        NodeLayoutData result = LayoutdataFactory.eINSTANCE.createNodeLayoutData();
        Dimension primarySize = new Dimension(0, 0);
        Point relativeLocation = editPart.getFigure().getBounds().getLocation().getCopy();
        FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)editPart.getFigure(), (Point)relativeLocation);
        boolean isCollapsed = false;
        if (new DDiagramElementQuery((DDiagramElement)node.getElement()).isIndirectlyCollapsed()) {
            isCollapsed = true;
        }
        if (isCollapsed) {
            NodeQuery nodeQuery;
            Option<Bounds> option;
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Bounds && (option = (nodeQuery = new NodeQuery(node)).getExtendedBounds()).some()) {
                Bounds unCollapseBounds = (Bounds)option.get();
                int deltaX = ((Bounds)layoutConstraint).getX() - unCollapseBounds.getX();
                int deltaY = ((Bounds)layoutConstraint).getY() - unCollapseBounds.getY();
                relativeLocation.setLocation(relativeLocation.x - deltaX, relativeLocation.y - deltaY);
                primarySize = new Dimension(unCollapseBounds.getWidth(), unCollapseBounds.getHeight());
            }
        } else {
            Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            primarySize = new Dimension(width.intValue(), height.intValue());
            if (width == -1 || height == -1) {
                primarySize = editPart.getFigure().getSize().getCopy();
            }
        }
        if (parentLayoutData != null) {
            org.eclipse.sirius.diagram.layoutdata.Point parentAbsoluteLocation = LayoutDataHelper.INSTANCE.getAbsoluteLocation(parentLayoutData);
            relativeLocation.translate(-parentAbsoluteLocation.getX(), -parentAbsoluteLocation.getY());
        }
        result.setHeight(primarySize.height);
        result.setWidth(primarySize.width);
        org.eclipse.sirius.diagram.layoutdata.Point location = LayoutdataFactory.eINSTANCE.createPoint();
        location.setX(relativeLocation.x);
        location.setY(relativeLocation.y);
        result.setLocation(location);
        this.copyNodeStyleInLayoutData((AbstractLayoutData)result, (View)node);
        return result;
    }

    private void copyNodeStyleInLayoutData(AbstractLayoutData layoutData, View view) {
        if (view.getElement() instanceof DStylizable) {
            layoutData.setSiriusStyle((Style)SiriusCopier.Helper.copy((EObject)((DStylizable)view.getElement()).getStyle()));
        }
        SiriusCopier copierWithoutElementRef = new SiriusCopier(false, false);
        View viewCopy = (View)copierWithoutElementRef.copy((EObject)view);
        layoutData.setGmfView(viewCopy);
    }

    @Override
    public EdgeLayoutData createEdgeLayoutData(Edge gmfEdge, ConnectionEditPart connectionEditPart) {
        EdgeLayoutData result = LayoutdataFactory.eINSTANCE.createEdgeLayoutData();
        ConnectorStyle connectorStyle = (ConnectorStyle)gmfEdge.getStyle(NotationPackage.eINSTANCE.getConnectorStyle());
        if (connectorStyle != null) {
            result.setRouting(connectorStyle.getRouting().getValue());
            result.setJumpLinkStatus(connectorStyle.getJumpLinkStatus().getValue());
            result.setJumpLinkType(connectorStyle.getJumpLinkType().getValue());
            result.setReverseJumpLink(connectorStyle.isJumpLinksReverse());
            result.setSmoothness(connectorStyle.getSmoothness().getValue());
        }
        if (connectionEditPart != null) {
            PolylineConnectionEx polylineConnectionEx = (PolylineConnectionEx)connectionEditPart.getFigure();
            polylineConnectionEx.getConnectionRouter().route((Connection)polylineConnectionEx);
            Point originialSourceRefPoint = polylineConnectionEx.getSourceAnchor().getReferencePoint().getCopy();
            polylineConnectionEx.translateToRelative((Translatable)originialSourceRefPoint);
            result.setSourceRefPoint(this.createPoint(originialSourceRefPoint));
            Point originialTargetRefPoint = polylineConnectionEx.getTargetAnchor().getReferencePoint().getCopy();
            polylineConnectionEx.translateToRelative((Translatable)originialTargetRefPoint);
            result.setTargetRefPoint(this.createPoint(originialTargetRefPoint));
            this.initPointList((EList<org.eclipse.sirius.diagram.layoutdata.Point>)result.getPointList(), polylineConnectionEx.getPoints().getCopy());
        }
        if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
            result.setSourceTerminal(((IdentityAnchor)gmfEdge.getSourceAnchor()).getId());
        }
        if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
            result.setTargetTerminal(((IdentityAnchor)gmfEdge.getTargetAnchor()).getId());
        }
        this.copyNodeStyleInLayoutData((AbstractLayoutData)result, (View)gmfEdge);
        return result;
    }

    @Override
    public NodeLayoutData createLabelLayoutData(Node labelNode) {
        NodeLayoutData result = LayoutdataFactory.eINSTANCE.createNodeLayoutData();
        if (labelNode.getLayoutConstraint() instanceof Size) {
            Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)labelNode, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)labelNode, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            result.setWidth(width.intValue());
            result.setHeight(height.intValue());
        }
        Integer x = (Integer)ViewUtil.getStructuralFeatureValue((View)labelNode, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        Integer y = (Integer)ViewUtil.getStructuralFeatureValue((View)labelNode, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        org.eclipse.sirius.diagram.layoutdata.Point location = LayoutdataFactory.eINSTANCE.createPoint();
        location.setX(x.intValue());
        location.setY(y.intValue());
        result.setLocation(location);
        return result;
    }

    @Override
    public org.eclipse.sirius.diagram.layoutdata.Point getAbsoluteLocation(NodeLayoutData nodeLayoutData) {
        org.eclipse.sirius.diagram.layoutdata.Point result = this.getCopy(nodeLayoutData.getLocation());
        if (nodeLayoutData.eContainer() instanceof NodeLayoutData) {
            result = this.getTranslated(result, this.getAbsoluteLocation((NodeLayoutData)nodeLayoutData.eContainer()));
        }
        return result;
    }

    @Override
    public org.eclipse.sirius.diagram.layoutdata.Point getRelativeLocation(NodeLayoutData layoutData, IGraphicalEditPart editPart) {
        org.eclipse.sirius.diagram.layoutdata.Point result = this.getAbsoluteLocation(layoutData);
        Point p = new Point(result.getX(), result.getY());
        FigureUtilities.translateToRelativeByIgnoringScrollbar((IFigure)editPart.getFigure(), (Point)p);
        result.setX(p.x);
        result.setY(p.y);
        return result;
    }

    private org.eclipse.sirius.diagram.layoutdata.Point createPoint(Point draw2dPoint) {
        org.eclipse.sirius.diagram.layoutdata.Point newPoint = LayoutdataFactory.eINSTANCE.createPoint();
        newPoint.setX(draw2dPoint.x);
        newPoint.setY(draw2dPoint.y);
        return newPoint;
    }

    private void initPointList(EList<org.eclipse.sirius.diagram.layoutdata.Point> pointList, PointList draw2dPointsList) {
        int i = 0;
        while (i < draw2dPointsList.size()) {
            pointList.add((Object)this.createPoint(draw2dPointsList.getPoint(i)));
            ++i;
        }
    }

    private org.eclipse.sirius.diagram.layoutdata.Point getCopy(org.eclipse.sirius.diagram.layoutdata.Point point) {
        org.eclipse.sirius.diagram.layoutdata.Point copy = LayoutdataFactory.eINSTANCE.createPoint();
        copy.setX(point.getX());
        copy.setY(point.getY());
        return copy;
    }

    protected org.eclipse.sirius.diagram.layoutdata.Point getTranslated(org.eclipse.sirius.diagram.layoutdata.Point originalPoint, org.eclipse.sirius.diagram.layoutdata.Point pt) {
        org.eclipse.sirius.diagram.layoutdata.Point translatedPoint = LayoutdataFactory.eINSTANCE.createPoint();
        translatedPoint.setX(originalPoint.getX() + pt.getX());
        translatedPoint.setY(originalPoint.getY() + pt.getY());
        return translatedPoint;
    }

    @Override
    public org.eclipse.sirius.diagram.layoutdata.Point getTranslated(org.eclipse.sirius.diagram.layoutdata.Point originalPoint, Point pt) {
        org.eclipse.sirius.diagram.layoutdata.Point translatedPoint = LayoutdataFactory.eINSTANCE.createPoint();
        translatedPoint.setX(originalPoint.getX() + pt.x);
        translatedPoint.setY(originalPoint.getY() + pt.y);
        return translatedPoint;
    }

    @Override
    public Map<? extends LayoutDataKey, ? extends AbstractLayoutData> getRootLayoutData(Map<? extends LayoutDataKey, ? extends AbstractLayoutData> collection) {
        return Maps.filterValues(collection, ROOT_PREDICATE);
    }

    @Override
    public LayoutDataKey createKey(AbstractLayoutData layoutData) {
        AbstractSemanticLayoutDataKey result;
        if (layoutData instanceof NodeLayoutData) {
            result = new SemanticNodeLayoutDataKey(layoutData.getId());
        } else if (layoutData instanceof EdgeLayoutData) {
            result = new SemanticEdgeLayoutDataKey(layoutData.getId());
        } else {
            throw new IllegalArgumentException(MessageFormat.format(Messages.LayoutDataHelperImpl_unkownLayoutData, layoutData.getClass()));
        }
        return result;
    }
}

