/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.operation.IFileWriteOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.SourceFormatOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class CompilationUnitWriteOperation
implements IFileWriteOperation {
    private final IJavaProject m_project;
    private final IPackageFragmentRoot m_root;
    private final String m_packageName;
    private final String m_fileName;
    private final String m_content;
    private ICompilationUnit m_createdCompilationUnit;

    public CompilationUnitWriteOperation(IType existingJdtType, String content) {
        this(((IType)Validate.notNull((Object)existingJdtType)).getCompilationUnit(), content);
    }

    public CompilationUnitWriteOperation(ICompilationUnit existingUnit, String content) {
        this((IPackageFragment)((ICompilationUnit)Validate.notNull((Object)existingUnit)).getAncestor(4), existingUnit.getElementName(), content);
    }

    public CompilationUnitWriteOperation(IPackageFragment pck, String fileName, String content) {
        this((IPackageFragmentRoot)((IPackageFragment)Validate.notNull((Object)pck)).getAncestor(3), pck.getElementName(), fileName, content);
    }

    public CompilationUnitWriteOperation(IPackageFragmentRoot srcFolder, ICompilationUnitSourceBuilder contentBuilder) {
        this(srcFolder, contentBuilder, null);
    }

    public CompilationUnitWriteOperation(IPackageFragmentRoot srcFolder, ICompilationUnitSourceBuilder contentBuilder, IJavaEnvironment env) {
        this(srcFolder, contentBuilder.getPackageName(), contentBuilder.getElementName(), S2eUtils.createJavaCode((ISourceBuilder)contentBuilder, srcFolder.getJavaProject(), env));
    }

    public CompilationUnitWriteOperation(IPackageFragmentRoot srcFolder, String packageName, String fileName, String content) {
        this.m_root = (IPackageFragmentRoot)Validate.notNull((Object)srcFolder);
        this.m_project = srcFolder.getJavaProject();
        this.m_packageName = StringUtils.isBlank((CharSequence)packageName) ? "" : packageName;
        this.m_fileName = (String)Validate.notNull((Object)fileName);
        this.m_content = content;
    }

    @Override
    public String getOperationName() {
        StringBuilder sb = new StringBuilder("write ");
        sb.append(this.getSourceFolder().getPath().toString()).append('/');
        if (!this.getPackageName().isEmpty()) {
            sb.append(this.getPackageName().replace('.', '/')).append('/');
        }
        sb.append(this.getFileName());
        return sb.toString();
    }

    public ICompilationUnit getCreatedCompilationUnit() {
        return this.m_createdCompilationUnit;
    }

    @Override
    public void validate() {
    }

    @Override
    public IResource getAffectedResource() {
        IResource result = this.getSourceFolder().getResource();
        IPackageFragment packageFragment = this.getSourceFolder().getPackageFragment(this.getPackageName());
        if (packageFragment.exists()) {
            result = packageFragment.getResource();
            ICompilationUnit compilationUnit = packageFragment.getCompilationUnit(this.getFileName());
            if (compilationUnit.exists()) {
                result = compilationUnit.getResource();
            }
        }
        return result;
    }

    protected static String getSourceFormatted(String unformattedJavaSource, IJavaProject settings, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SourceFormatOperation op = new SourceFormatOperation(settings, new Document(unformattedJavaSource));
        op.validate();
        op.run(monitor, workingCopyManager);
        return op.getDocument().get();
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)4);
        try {
            String newSource = CompilationUnitWriteOperation.getSourceFormatted(this.getContent(), this.m_project, (IProgressMonitor)progress.newChild(0), workingCopyManager);
            if (progress.isCanceled()) {
                return;
            }
            progress.worked(1);
            IPackageFragment pck = this.getSourceFolder().getPackageFragment(this.getPackageName());
            if (!pck.exists()) {
                pck = this.getSourceFolder().createPackageFragment(this.getPackageName(), true, (IProgressMonitor)progress.newChild(0));
            }
            progress.worked(1);
            this.m_createdCompilationUnit = pck.getCompilationUnit(this.getFileName());
            if (!this.m_createdCompilationUnit.exists()) {
                this.m_createdCompilationUnit = pck.createCompilationUnit(this.getFileName(), newSource, true, (IProgressMonitor)progress.newChild(0));
                progress.worked(1);
                workingCopyManager.register(this.m_createdCompilationUnit, (IProgressMonitor)progress.newChild(0));
                progress.worked(1);
            } else {
                String oldSource = S2eUtils.getContentOfFile((IFile)this.m_createdCompilationUnit.getResource());
                progress.worked(1);
                if (!Objects.equals(oldSource, newSource)) {
                    workingCopyManager.register(this.m_createdCompilationUnit, (IProgressMonitor)progress.newChild(0));
                    IBuffer buffer = this.m_createdCompilationUnit.getBuffer();
                    buffer.setContents(newSource);
                }
                progress.worked(1);
            }
        }
        catch (Exception e) {
            SdkLog.error((String)"Could not {}", (Object[])new Object[]{this.getOperationName(), e});
        }
    }

    public IPackageFragmentRoot getSourceFolder() {
        return this.m_root;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getContent() {
        return this.m_content;
    }

    @Override
    public IFile getFile() {
        if (!S2eUtils.exists((IJavaElement)this.m_createdCompilationUnit)) {
            return null;
        }
        IResource resource = this.m_createdCompilationUnit.getResource();
        if (resource == null || !resource.exists() || resource.getType() != 1) {
            return null;
        }
        return (IFile)resource;
    }
}

