/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.rules;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.CaptureScreenshotException;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.rules.ErrorCollector;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ErrorCollectorWithScreenshot
extends ErrorCollector {
    private static final Logger log = Logger.getLogger(ErrorCollectorWithScreenshot.class);
    private Description description;

    public Statement apply(Statement base, Description description) {
        if (base instanceof AbstractStatementWithScreenshot) {
            this.description = description;
        }
        return super.apply(base, description);
    }

    public void addError(Throwable error) {
        try {
            ScreenshotCapturer.getInstance().captureScreenshotOnFailure(this.getConfig(), this.getScreenshotFilename());
        }
        catch (CaptureScreenshotException e) {
            e.printInfo(log);
        }
        super.addError(error);
    }

    private String getConfig() {
        String[] splited = this.description.getMethodName().split(" ");
        return splited.length < 1 ? "no-configuration" : splited[1];
    }

    private String getTestMethodName() {
        String[] splited = this.description.getMethodName().split(" ");
        return splited[0];
    }

    private Class<?> getTestClass() {
        return this.description.getTestClass();
    }

    public String getScreenshotDirPath() {
        return ScreenshotCapturer.getInstance().getScreenshotDirPath(this.getConfig());
    }

    private String getScreenshotFilename() {
        return ScreenshotCapturer.getScreenshotFileName(this.getTestClass(), this.getTestMethodName(), null);
    }
}

