/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunIAfterTestExtensions
extends AbstractStatementWithScreenshot {
    private static final Logger log = Logger.getLogger(RunIAfterTestExtensions.class);
    private final List<IAfterTest> afters;

    public RunIAfterTestExtensions(String config, Statement next, TestClass testClass, FrameworkMethod method, Object target, List<IAfterTest> afters) {
        super(config, next, testClass, method, target);
        this.afters = afters;
    }

    public void evaluate() throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.nextStatement.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        IAfterTest after = null;
        log.debug("Run after test extensions for test class " + this.testClass.getJavaClass().getName());
        for (IAfterTest each : this.afters) {
            try {
                after = each;
                if (!after.hasToRun()) continue;
                log.debug("Run method runAfterTest() of class " + after.getClass().getCanonicalName());
                after.runAfterTest(this.config, this.target, this.frameworkMethod);
            }
            catch (Throwable e) {
                if (ScreenshotCapturer.shouldCaptureScreenshotOnException(e)) {
                    log.error("Run method runAfterTest() of class " + after.getClass().getCanonicalName() + " failed", e);
                    this.createScreenshot("AfterTestExt", after.getClass());
                }
                errors.add(e);
            }
        }
        MultipleFailureException.assertEmpty(errors);
    }
}

