/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.launching;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.utils.BaseProcess;
import org.eclipse.ocl.examples.debug.vm.utils.MiscUtil;
import org.eclipse.ocl.examples.debug.vm.utils.SafeRunner;
import org.eclipse.ocl.examples.debug.vm.utils.ShallowProcess;
import org.eclipse.ocl.examples.debug.vm.utils.StreamsProxy;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConstants;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiIncrementalExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class QVTiLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements QVTiLaunchConstants {
    public static final @NonNull String @NonNull [] compileStepKeys = new String[]{"QVTi"};
    public static final @NonNull String @NonNull [] generateStepKeys = new String[]{"Java", "Class"};
    protected static final int LAUNCH_ERROR_CODE = 210;
    protected static final IStatus fgLaunchErrorStatus = new Status(4, "org.eclipse.qvtd.debug", 210, "Launch configuration error", null);

    protected @NonNull DefaultCompilerOptions createCompilerOptions() {
        return new DefaultCompilerOptions();
    }

    protected @NonNull QVTiExecutor createExecutor(@NonNull QVTiEnvironmentFactory envFactory, @NonNull ImperativeTransformation transformation) {
        return new QVTiIncrementalExecutor(envFactory, transformation, QVTiIncrementalExecutor.Mode.LAZY);
    }

    protected @NonNull QVTiDebugCore getDebugCore() {
        return QVTiDebugCore.INSTANCE;
    }

    protected @NonNull URI getTransformationURI(ILaunchConfiguration configuration) throws CoreException {
        String txName = configuration.getAttribute("tx", "");
        return URI.createURI((String)txName, (boolean)true);
    }

    public void launch(final ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            boolean interpreted = configuration.getAttribute("interpreted", false);
            final boolean traceEvaluation = configuration.getAttribute("console-trace", false);
            final Map inMap = configuration.getAttribute("in", EMPTY_MAP);
            final Map outMap = configuration.getAttribute("out", EMPTY_MAP);
            final URI txURI = this.getTransformationURI(configuration);
            BasicMonitor execMonitor = new BasicMonitor();
            StreamsProxy streamsProxy = new StreamsProxy();
            BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

                public void run() throws Exception {
                    QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(BasicProjectManager.createDefaultProjectManager(), null);
                    if (traceEvaluation) {
                        environmentFactory.setEvaluationTracingEnabled(true);
                    }
                    ImperativeTransformation transformation = QVTimperativeUtil.loadTransformation((QVTbaseEnvironmentFactory)environmentFactory, (URI)txURI, (boolean)environmentFactory.keepDebug());
                    QVTiExecutor executor = QVTiLaunchConfigurationDelegate.this.createExecutor(environmentFactory, transformation);
                    for (TypedModel typedModel : ClassUtil.nullFree((EList)transformation.getModelParameter())) {
                        for (Package asPackage : ClassUtil.nullFree((EList)typedModel.getUsedPackage())) {
                            String nsURI;
                            EObject esObject = asPackage.getESObject();
                            if (!(esObject instanceof EPackage) || (nsURI = ((EPackage)esObject).getNsURI()) == null) continue;
                            environmentFactory.getResourceSet().getPackageRegistry().put((Object)nsURI, (Object)esObject);
                        }
                    }
                    for (String inName : inMap.keySet()) {
                        if (inName == null) continue;
                        URI inURI = URI.createURI((String)((String)inMap.get(inName)), (boolean)true);
                        executor.loadModel(inName, inURI, null);
                    }
                    for (String outName : outMap.keySet()) {
                        if (outName == null) continue;
                        URI outURI = URI.createURI((String)((String)outMap.get(outName)), (boolean)true);
                        executor.createModel(outName, outURI, null);
                    }
                    executor.execute();
                    executor.saveModels();
                }
            };
            r = SafeRunner.getSafeRunnable((BaseProcess.IRunnable)r);
            final ShallowProcess process = new ShallowProcess(launch, r, (Monitor)execMonitor){
                boolean isTerminated;
                private final /* synthetic */ Monitor val$execMonitor;
                {
                    this.val$execMonitor = monitor;
                    super($anonymous0, $anonymous1);
                    this.isTerminated = false;
                }

                public void terminate() throws DebugException {
                    this.val$execMonitor.setCanceled(true);
                    this.isTerminated = true;
                    super.terminate();
                }

                public boolean isTerminated() {
                    return this.isTerminated || super.isTerminated();
                }

                public boolean canTerminate() {
                    return !this.isTerminated();
                }
            };
            process.setStreamsProxy((IStreamsProxy)streamsProxy);
            Thread processThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block7: {
                        try {
                            process.run();
                        }
                        catch (Exception e) {
                            if (e instanceof VMRuntimeException) break block7;
                            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(fgLaunchErrorStatus);
                            if (statusHandler != null) {
                                Status actualStatus = new Status(4, "org.eclipse.qvtd.debug", 210, e.getMessage(), (Throwable)(e.getMessage() == null ? e : null));
                                try {
                                    statusHandler.handleStatus((IStatus)actualStatus, (Object)configuration);
                                }
                                catch (CoreException coreExc) {
                                    QVTiLaunchConfigurationDelegate.this.getDebugCore().log(coreExc.getStatus());
                                }
                            }
                            QVTiLaunchConfigurationDelegate.this.getDebugCore().error("Execution of launch '" + configuration.getName() + "' failed", e);
                        }
                    }
                    try {
                        launch.terminate();
                    }
                    catch (DebugException e) {
                        QVTiLaunchConfigurationDelegate.this.getDebugCore().log(e.getStatus());
                    }
                }
            }, "QVTi Run");
            processThread.start();
        }
        catch (Exception e) {
            throw new CoreException(MiscUtil.makeErrorStatus((Exception)e));
        }
    }
}

