/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.util;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class ValueSortedMap {
    private static long getMapSizeRecursively(Map inmap) {
        long ret = 0L;
        for (Map.Entry entry : inmap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                long size = ValueSortedMap.getMapSizeRecursively((Map)entry.getValue());
                ret += size;
                continue;
            }
            Long val = (Long)entry.getValue();
            ret += val.longValue();
        }
        return ret;
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> Map<K, V> getMap(Map<K, V> inmap) {
        ValueComparator<K, V> cmp = new ValueComparator<K, V>(inmap, false);
        TreeMap<K, V> map = new TreeMap<K, V>(cmp);
        map.putAll(inmap);
        return map;
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> Map<K, V> getMapDesc(Map<K, V> inmap) {
        ValueComparator<K, V> cmp = new ValueComparator<K, V>(inmap, true);
        TreeMap<K, V> map = new TreeMap<K, V>(cmp);
        map.putAll(inmap);
        return map;
    }

    public static <K extends Comparable<K>, V extends Map> Map<K, V> getNestedMap(Map<K, V> inmap) {
        NestedMapValueComparator<K, V> cmp = new NestedMapValueComparator<K, V>(inmap, false);
        TreeMap<K, V> map = new TreeMap<K, V>(cmp);
        map.putAll(inmap);
        return map;
    }

    public static <K extends Comparable<K>, V extends Map> Map<K, V> getNestedMapDesc(Map<K, V> inmap) {
        NestedMapValueComparator<K, V> cmp = new NestedMapValueComparator<K, V>(inmap, true);
        TreeMap<K, V> map = new TreeMap<K, V>(cmp);
        map.putAll(inmap);
        return map;
    }

    private static class NestedMapValueComparator<K extends Comparable<K>, V extends Map>
    implements Comparator<K> {
        private Map<K, V> map = null;
        private boolean desc = false;

        NestedMapValueComparator(Map<K, V> inmap, boolean indesc) {
            this.map = inmap;
            this.desc = indesc;
        }

        @Override
        public int compare(K k1, K k2) {
            Map map1 = (Map)this.map.get(k1);
            Map map2 = (Map)this.map.get(k2);
            int ret = Long.signum(ValueSortedMap.getMapSizeRecursively(map1) - ValueSortedMap.getMapSizeRecursively(map2));
            if (this.desc) {
                ret = -ret;
            }
            if (ret != 0) {
                return ret;
            }
            ret = k1.compareTo(k2);
            if (ret != 0) {
                return ret;
            }
            return 1;
        }
    }

    private static class ValueComparator<K extends Comparable<K>, V extends Comparable<V>>
    implements Comparator<K> {
        private Map<K, V> map = null;
        private boolean desc = false;

        ValueComparator(Map<K, V> inmap, boolean indesc) {
            this.map = inmap;
            this.desc = indesc;
        }

        @Override
        public int compare(K k1, K k2) {
            Comparable v1 = (Comparable)this.map.get(k1);
            Comparable v2 = (Comparable)this.map.get(k2);
            int ret = v1.compareTo(v2);
            if (this.desc) {
                ret = -ret;
            }
            if (ret != 0) {
                return ret;
            }
            ret = k1.compareTo(k2);
            if (ret != 0) {
                return ret;
            }
            return 1;
        }
    }
}

