/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.concurrent.TrackableTimerTask;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;
import org.eclipse.net4j.util.om.monitor.NestedMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class AbstractMonitor
implements OMMonitor {
    private static final boolean CHECK_BEGIN = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.util.om.monitor.CheckBegin");
    private static final long NOT_BEGUN = -1L;
    private double totalWork = -1.0;
    private double work;

    public boolean hasBegun() throws MonitorCanceledException {
        this.checkCanceled();
        return this.totalWork != -1.0;
    }

    public OMMonitor begin(double totalWork) throws MonitorCanceledException {
        this.checkCanceled();
        this.totalWork = totalWork;
        return this;
    }

    public OMMonitor begin() throws MonitorCanceledException {
        return this.begin(1.0);
    }

    public void worked(double work) throws MonitorCanceledException {
        this.checkBegun();
        this.work += work;
    }

    public void worked() throws MonitorCanceledException {
        this.worked(1.0);
    }

    public OMMonitor fork(double work) {
        this.checkBegun();
        return this.createNestedMonitor(work);
    }

    public OMMonitor fork() {
        return this.fork(1.0);
    }

    public OMMonitor.Async forkAsync(double work) {
        this.checkBegun();
        AsyncTimerTask asyncTimerTask = this.createAsyncTimerTask(work);
        if (asyncTimerTask == null) {
            throw new NullPointerException("No async timer task has been created");
        }
        long period = this.getAsyncSchedulePeriod();
        this.scheduleAtFixedRate(asyncTimerTask, period, period);
        return asyncTimerTask;
    }

    public OMMonitor.Async forkAsync() {
        return this.forkAsync(1.0);
    }

    public void done() {
        double rest;
        if (!this.isCanceled() && (rest = this.totalWork - this.work) > 0.0) {
            this.worked(rest);
        }
    }

    public double getTotalWork() {
        return this.totalWork;
    }

    public double getWork() {
        return this.work;
    }

    public double getWorkPercent() {
        return AbstractMonitor.percent(this.work, this.totalWork);
    }

    protected OMMonitor createNestedMonitor(double work) {
        return new NestedMonitor(this, work);
    }

    protected AsyncTimerTask createAsyncTimerTask(double work) {
        return new AsyncTimerTask(this, work, 1000.0);
    }

    protected abstract long getAsyncSchedulePeriod();

    protected abstract Timer getTimer();

    protected abstract void scheduleAtFixedRate(TimerTask var1, long var2, long var4);

    private void checkBegun() throws MonitorCanceledException {
        if (CHECK_BEGIN && !this.hasBegun()) {
            throw new IllegalStateException("begin() has not been called");
        }
    }

    protected static double percent(double part, double whole) {
        return Math.min(part * 100.0 / whole, 100.0);
    }

    public static class AsyncTimerTask
    extends TrackableTimerTask
    implements OMMonitor.Async {
        private OMMonitor monitor;
        private boolean canceled;

        public AsyncTimerTask(AbstractMonitor parent, double parentWork, double timeFactor) {
            this.monitor = parent.fork(parentWork);
            this.monitor.begin();
        }

        public void run() {
            try {
                if (!this.canceled && this.monitor != null) {
                    double work = 1.0 - this.monitor.getWork();
                    this.monitor.worked(work / 10.0);
                }
            }
            catch (Exception ex) {
                OM.LOG.error("AsyncTimerTask failed", ex);
            }
        }

        public void stop() {
            try {
                if (this.monitor != null) {
                    this.monitor.done();
                }
                this.cancel();
            }
            catch (Exception ex) {
                OM.LOG.error(ex);
            }
        }

        public boolean cancel() {
            this.canceled = true;
            this.monitor = null;
            return super.cancel();
        }
    }
}

