/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.sdk.java;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.IProgressService;

public class TestJavaProject {
    public IProject project;
    public IJavaProject javaProject;
    private IPackageFragmentRoot sourceFolder;

    public TestJavaProject(String name) throws CoreException, InvocationTargetException, InterruptedException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject(name);
        this.project.create(null);
        this.project.open(null);
        this.javaProject = JavaCore.create((IProject)this.project);
        IFolder binFolder = this.createBinFolder();
        this.setJavaNature();
        this.javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.createOutputFolder(binFolder);
        this.addSystemLibraries();
    }

    public IProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void build() throws CoreException, InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                TestJavaProject.this.project.build(6, null);
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        service.run(true, true, (IRunnableWithProgress)op);
    }

    public IPackageFragment createPackage(String name) throws CoreException {
        if (this.sourceFolder == null) {
            this.sourceFolder = this.createSourceFolder();
        }
        return this.sourceFolder.createPackageFragment(name, false, null);
    }

    public IType createType(IPackageFragment pack, String cuName, String source) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        buf.append("package " + pack.getElementName() + ";\n");
        buf.append("\n");
        buf.append(source);
        ICompilationUnit cu = pack.createCompilationUnit(cuName, buf.toString(), false, null);
        return cu.getTypes()[0];
    }

    private IFolder createBinFolder() throws CoreException {
        IFolder binFolder = this.project.getFolder("bin");
        binFolder.create(false, true, null);
        return binFolder;
    }

    private void setJavaNature() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        this.project.setDescription(description, null);
    }

    private void createOutputFolder(IFolder binFolder) throws JavaModelException {
        IPath outputLocation = binFolder.getFullPath();
        this.javaProject.setOutputLocation(outputLocation, null);
    }

    private IPackageFragmentRoot createSourceFolder() throws CoreException {
        IFolder folder = this.project.getFolder("src");
        folder.create(false, true, null);
        IPackageFragmentRoot root = this.javaProject.getPackageFragmentRoot((IResource)folder);
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)root.getPath());
        this.javaProject.setRawClasspath(newEntries, null);
        return root;
    }

    private void addSystemLibraries() throws JavaModelException {
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaRuntime.getDefaultJREContainerEntry();
        this.javaProject.setRawClasspath(newEntries, null);
    }

    public void addJar(Plugin plugin, String jar) throws MalformedURLException, IOException, JavaModelException {
        Path result = this.findFileInPlugin(plugin, jar);
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newLibraryEntry((IPath)result, null, null);
        this.javaProject.setRawClasspath(newEntries, null);
    }

    private Path findFileInPlugin(Plugin plugin, String file) throws MalformedURLException, IOException {
        URL pluginURL = plugin.getBundle().getEntry("/");
        URL jarURL = new URL(pluginURL, file);
        URL localJarURL = FileLocator.toFileURL((URL)jarURL);
        return new Path(localJarURL.getPath());
    }

    public void waitForIndexer() throws JavaModelException {
        new SearchEngine().searchAllTypeNames(null, null, 0, 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]), new TypeNameRequestor(){}, 3, null);
    }
}

