/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.template.imp;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.actions.handlers.TemplateHandler;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.WizardHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;

public class ImportTemplateWizardPage
extends WizardPage {
    static final Logger logger = Logger.getLogger(ImportTemplateWizardPage.class);
    protected TreeViewer packageViewer;
    protected List listbox;
    protected Button addButton;
    protected Button removeButton;
    protected Button removeAllButton;
    protected Text templateField;
    protected String loadedModedFile;
    protected ResourceSet resourceSet;
    protected String modelError = PluginProperties.wizards_ModelError_label;
    private boolean creationMode = false;
    protected ModifyListener addvalidator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ImportTemplateWizardPage.this.addButton.setEnabled(ImportTemplateWizardPage.this.templateField.getText().length() != 0);
        }
    };

    public ImportTemplateWizardPage(String pageId, IWorkbench workbench) {
        super(pageId);
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)GeneralHelper.getActiveInstance().getAdapter(AdapterFactory.class);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(10, false));
        composite.setLayoutData((Object)WizardHelper.createData(4, 4, true, false, -1, -1));
        Tree packageTree = WizardHelper.createPackageTree(composite);
        this.packageViewer = GeneralHelper.getActiveInstance() == null ? WizardHelper.createPackageViewer(null, packageTree) : WizardHelper.createPackageViewer(this.getAdapterFactory(), packageTree);
        this.listbox = WizardHelper.createListBox(composite);
        this.listbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportTemplateWizardPage.this.removeButton.setEnabled(ImportTemplateWizardPage.this.listbox.getSelectionIndex() != -1);
                ImportTemplateWizardPage.this.removeAllButton.setEnabled(ImportTemplateWizardPage.this.listbox.getSelectionIndex() != -1);
                ImportTemplateWizardPage.this.loadedModedFile = WizardHelper.showModelInBox(ImportTemplateWizardPage.this.listbox, ImportTemplateWizardPage.this.packageViewer, ImportTemplateWizardPage.this.resourceSet, ImportTemplateWizardPage.this.loadedModedFile, ImportTemplateWizardPage.this.modelError);
            }
        });
        this.addButton = WizardHelper.createAddButton(composite);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardHelper.addListBox(ImportTemplateWizardPage.this.templateField, ImportTemplateWizardPage.this.listbox);
                ImportTemplateWizardPage.this.selectFileField();
                ImportTemplateWizardPage.this.setPageComplete(ImportTemplateWizardPage.this.validatePage());
            }
        });
        this.removeButton = WizardHelper.createRemoveButton(composite);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardHelper.removeListBoxItem(ImportTemplateWizardPage.this.listbox);
                ImportTemplateWizardPage.this.setPageComplete(ImportTemplateWizardPage.this.validatePage());
            }
        });
        this.removeAllButton = WizardHelper.createRemoveAllButton(composite);
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardHelper.removeAllListBoxItems(ImportTemplateWizardPage.this.listbox);
                ImportTemplateWizardPage.this.selectFileField();
                ImportTemplateWizardPage.this.setPageComplete(ImportTemplateWizardPage.this.validatePage());
            }
        });
        this.templateField = WizardHelper.createTemplateField(composite);
        this.templateField.addModifyListener(this.addvalidator);
        Button browseButton = WizardHelper.createBrowseButton(composite);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String fileExtension = WEEditor.getTemplateExtension();
                String fileExtensionName = PluginProperties.wizards_Files_templatefiles;
                String filePath = TemplateHandler.saveFilePathDialog(ImportTemplateWizardPage.this.getShell(), fileExtension, fileExtensionName, 4096);
                if (filePath != null) {
                    if (!filePath.endsWith("." + fileExtension)) {
                        filePath = String.valueOf(filePath) + "." + fileExtension;
                    }
                    ImportTemplateWizardPage.this.templateField.setText(filePath);
                }
            }
        });
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    public IWizardPage getNextPage() {
        if (this.creationMode) {
            return super.getNextPage();
        }
        return null;
    }

    public void setCreationMode(boolean creationMode) {
        this.creationMode = creationMode;
    }

    public boolean validatePage() {
        if (this.creationMode) {
            return true;
        }
        if (this.getContainer().getCurrentPage() != this) {
            return false;
        }
        if (this.listbox.getItemCount() == 0) {
            this.setMessage(PluginProperties.wizards_ImportNoSelected_error);
            return false;
        }
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.templateField.setFocus();
        }
    }

    public void selectFileField() {
        this.templateField.selectAll();
        this.templateField.setFocus();
    }

    public ArrayList getTemplates() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.listbox.getItems().length) {
            if (!this.modelError.equals(this.listbox.getItems()[i])) {
                result.add(new String(this.listbox.getItems()[i]));
            }
            ++i;
        }
        return result;
    }

    public void dispose() {
        this.packageViewer = null;
        this.listbox.dispose();
        this.addButton.dispose();
        this.removeButton.dispose();
        this.removeAllButton.dispose();
        this.templateField.dispose();
        this.resourceSet = null;
        super.dispose();
    }
}

