/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.LiteralToken;
import org.eclipse.jubula.client.core.utils.SimpleStringConverter;
import org.eclipse.jubula.client.core.utils.SimpleValueToken;
import org.eclipse.jubula.client.core.utils.VariableToken;
import org.eclipse.jubula.client.ui.rcp.widgets.FunctionProposalProvider;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;

public class ParamProposalProvider
implements IContentProposalProvider {
    private Map<String, String> m_valueToComment = new HashMap<String, String>();
    private INodePO m_node;
    private IParamDescriptionPO m_paramDesc;
    private FunctionProposalProvider m_functionProposalProvider = new FunctionProposalProvider();

    public ParamProposalProvider(String[] valueSet, INodePO node, IParamDescriptionPO paramDesc) {
        String[] stringArray = valueSet;
        int n = valueSet.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string != null) {
                this.m_valueToComment.put(string, "");
            }
            ++n2;
        }
        this.m_node = node;
        this.m_paramDesc = paramDesc;
    }

    public ParamProposalProvider(Map<String, String> valueSet, INodePO node, IParamDescriptionPO paramDesc) {
        this.m_valueToComment = valueSet;
        this.m_node = node;
        this.m_paramDesc = paramDesc;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        Object[] functionProposals = this.m_functionProposalProvider.getProposals(contents, position);
        if (!ArrayUtils.isEmpty((Object[])functionProposals)) {
            return functionProposals;
        }
        if (position != contents.length()) {
            return new IContentProposal[0];
        }
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>(20);
        if (this.m_valueToComment != null) {
            proposals.addAll(this.getValueSetProposals(contents, position));
        }
        proposals.addAll(this.getParentParamProposals(contents));
        proposals.addAll(this.getParentVariableProposals(contents, "guidancer.datatype.Variable".equals(this.m_paramDesc.getType())));
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private Collection<IContentProposal> getParentParamProposals(String contents) {
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        INodePO node = this.m_node;
        while (node != null && !(node instanceof ISpecTestCasePO)) {
            node = node.getParentNode();
        }
        if (node == null || contents == null) {
            return proposals;
        }
        ISpecTestCasePO paramNode = (ISpecTestCasePO)node;
        if (!(this.m_node instanceof ISpecTestCasePO)) {
            String p;
            if (this.m_paramDesc != null && paramNode != null && !paramNode.isInterfaceLocked().booleanValue() && !paramNode.getParamNames().contains(this.m_paramDesc.getName()) && (p = String.valueOf('=') + this.getPredefinedParamName()).startsWith(contents)) {
                proposals.add(new ParamProposal(p.substring(contents.length()), p));
            }
            if (paramNode != null) {
                List params = paramNode.getParameterList();
                for (IParamDescriptionPO param : params) {
                    String p2;
                    String parType = this.m_paramDesc.getType();
                    if (!"java.lang.String".equals(parType) && !param.getType().equals(parType) || !(p2 = String.valueOf('=') + param.getName()).startsWith(contents)) continue;
                    proposals.add(new ParamProposal(p2.substring(contents.length()), p2));
                }
            }
        }
        return proposals;
    }

    private String getPredefinedParamName() {
        String p = this.m_paramDesc.getName();
        p = StringUtils.replaceChars((String)p, (char)' ', (char)'_');
        p = StringUtils.replaceChars((String)p, (char)'-', (char)'_');
        p = p.toUpperCase();
        return p;
    }

    private Collection<IContentProposal> getParentVariableProposals(String content, boolean varTypeParam) {
        ArrayList<IContentProposal> props = new ArrayList<IContentProposal>();
        if (this.m_node == null) {
            return props;
        }
        INodePO spec = this.m_node.getSpecAncestor();
        if (spec == null || content == null) {
            return props;
        }
        int varNameStart = content.lastIndexOf(36);
        if (varNameStart == -1 && !varTypeParam && content.length() > 0 || varNameStart != -1 && varTypeParam) {
            return props;
        }
        String proposalStart = varNameStart == -1 && !varTypeParam ? String.valueOf('$') : "";
        boolean needClose = false;
        if (++varNameStart < content.length() && !varTypeParam) {
            if (content.charAt(varNameStart) == '{') {
                ++varNameStart;
                needClose = true;
            }
        } else if (!varTypeParam) {
            proposalStart = String.valueOf(proposalStart) + '{';
            needClose = true;
        }
        String varNamePart = varNameStart < content.length() ? content.substring(varNameStart) : "";
        Set<String> varNames = this.collectVariableNames(spec);
        for (String varName : varNames) {
            if (!varName.startsWith(varNamePart)) continue;
            String proposal = proposalStart;
            if (!varName.equals(varNamePart)) {
                proposal = String.valueOf(proposal) + varName.substring(varNamePart.length());
            }
            if (needClose) {
                proposal = String.valueOf(proposal) + '}';
            }
            props.add(new ParamProposal(proposal, String.valueOf(content) + proposal));
        }
        return props;
    }

    private Set<String> collectVariableNames(INodePO spec) {
        HashSet<String> varNames = new HashSet<String>();
        Iterator it = spec.getAllNodeIter();
        while (it.hasNext()) {
            INodePO next = (INodePO)it.next();
            if (!(next instanceof IParamNodePO)) continue;
            IParamNodePO paramNode = (IParamNodePO)next;
            ITDManager man = paramNode.getDataManager();
            for (IParamDescriptionPO param : paramNode.getParameterList()) {
                int i = 0;
                while (i < man.getDataSetCount()) {
                    String data = null;
                    try {
                        data = man.getCell(i, param);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    if (data != null) {
                        SimpleStringConverter conv = new SimpleStringConverter(data);
                        if ("guidancer.datatype.Variable".equals(param.getType())) {
                            IParamValueToken token;
                            List toks = conv.getTokens();
                            if (toks.size() == 1 && ((token = (IParamValueToken)toks.get(0)) instanceof LiteralToken || token instanceof SimpleValueToken)) {
                                try {
                                    varNames.add(token.getExecutionString(null));
                                }
                                catch (InvalidDataException invalidDataException) {}
                            }
                        } else {
                            for (IParamValueToken token : conv.getTokens()) {
                                if (!(token instanceof VariableToken)) continue;
                                String varName = ((VariableToken)token).getGuiString();
                                if (varName.length() > 1 && varName.charAt(1) == '{') {
                                    varNames.add(varName.substring(2, varName.length() - 1));
                                    continue;
                                }
                                varNames.add(varName.substring(1));
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return varNames;
    }

    private Collection<IContentProposal> getValueSetProposals(String contents, int position) {
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        StringBuilder sb = new StringBuilder(contents);
        sb.delete(position, sb.length());
        sb.delete(0, sb.lastIndexOf(" ") + 1);
        for (Map.Entry<String, String> entry : this.m_valueToComment.entrySet()) {
            String predefValue = entry.getKey();
            String comment = entry.getValue();
            if (predefValue.startsWith(sb.toString())) {
                proposals.add(new ParamProposal(predefValue.substring(sb.length()), predefValue, comment));
                continue;
            }
            if (!predefValue.startsWith(contents)) continue;
            proposals.add(new ParamProposal(predefValue.substring(contents.length()), predefValue, comment));
        }
        return proposals;
    }

    public static class ParamProposal
    implements IContentProposal {
        private String m_displayValue;
        private String m_content;
        private String m_description;

        public ParamProposal(String content) {
            this(content, null);
        }

        public ParamProposal(String content, String displayValue) {
            this.m_content = content;
            this.m_displayValue = displayValue;
        }

        public ParamProposal(String content, String displayValue, String description) {
            this(content, displayValue);
            this.m_description = description;
        }

        public String getContent() {
            return this.m_content;
        }

        public int getCursorPosition() {
            return this.m_content.length();
        }

        public String getDescription() {
            return StringUtils.defaultIfBlank((String)this.m_description, null);
        }

        public String getLabel() {
            return this.m_displayValue;
        }
    }
}

