/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.contentassist.TestDataCubeRefContentProposalProvider;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.ContentAssistedTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.IParameterPropertyController;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.factory.TestDataControlFactory;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.DisabledLabelProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.ParameterValueLabelProvider;
import org.eclipse.jubula.client.ui.rcp.validator.TestDataCubeReferenceValidator;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecTestCaseGUIPropertySource
extends AbstractNodePropertySource {
    public static final String P_ELEMENT_DISPLAY_PARAM_LOCKED = org.eclipse.jubula.client.ui.rcp.i18n.Messages.SpecTestCaseGUIPropertySourceLockedParameters;
    public static final String P_ELEMENT_DISPLAY_DATEFILE = org.eclipse.jubula.client.ui.rcp.i18n.Messages.SpecTestCaseGUIPropertySourceTestCaseFileName;
    public static final String P_ELEMENT_DISPLAY_REFDATA = org.eclipse.jubula.client.ui.rcp.i18n.Messages.SpecTestCaseGUIPropertySourceTestCaseReferencedTestData;
    public static final String P_ELEMENT_DISPLAY_DATASOURCE = org.eclipse.jubula.client.ui.rcp.i18n.Messages.SpecTestCaseGUIPropertySourceDataSource;
    public static final String P_PARAMETER_CAT = org.eclipse.jubula.client.ui.rcp.i18n.Messages.SpecTestCaseGUIPropertySourceParameter;
    public static final String P_TESTDATA_CAT = org.eclipse.jubula.client.ui.rcp.i18n.Messages.SpecTestCaseGUIPropertySourceTestdataCategory;
    private static final Logger LOG = LoggerFactory.getLogger(SpecTestCaseGUIPropertySource.class);
    private IPropertyDescriptor m_namePropDesc = null;
    private IPropertyDescriptor m_lockPropDesc = null;
    private PropertyDescriptor m_extDataPropDesc = null;
    private PropertyDescriptor m_referencedCubePropDesc = null;
    private IPropertyDescriptor m_oMCatPropDesc;

    public SpecTestCaseGUIPropertySource(ITestCasePO testCase) {
        super((INodePO)testCase);
    }

    @Override
    protected void initPropDescriptor() {
        if (!this.getPropertyDescriptorList().isEmpty()) {
            this.clearPropertyDescriptors();
        }
        if (this.m_namePropDesc == null) {
            this.m_namePropDesc = new TextPropertyDescriptor((Object)new AbstractNodePropertySource.ElementNameController(), org.eclipse.jubula.client.ui.rcp.i18n.Messages.SpecTestCaseGUIPropertySourceTestCaseName);
        }
        this.addPropertyDescriptor(this.m_namePropDesc);
        super.initPropDescriptor();
        if (this.getTaskIdPropDesc() == null) {
            this.setTaskIdPropDesc((IPropertyDescriptor)new TextPropertyDescriptor((Object)new AbstractNodePropertySource.TaskIdController(), Messages.AbstractGuiNodePropertySourceTaskId));
        }
        this.addPropertyDescriptor(this.getTaskIdPropDesc());
        this.addPropertyDescriptor(this.getDataSourcePropertyDescr(new SpecTestCaseTestDataSourceController(this)));
        if (this.m_extDataPropDesc == null) {
            this.m_extDataPropDesc = new TextPropertyDescriptor((Object)new ExternalDataController(this), P_ELEMENT_DISPLAY_DATEFILE);
            this.m_extDataPropDesc.setCategory(P_TESTDATA_CAT);
        }
        this.addPropertyDescriptor((IPropertyDescriptor)this.m_extDataPropDesc);
        if (this.m_referencedCubePropDesc == null) {
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            TestDataCubeRefContentProposalProvider dataCubeRefProposalProvider = null;
            TestDataCubeReferenceValidator dataCubeRefValidator = null;
            if (activeProject != null) {
                dataCubeRefProposalProvider = new TestDataCubeRefContentProposalProvider(activeProject, (IParameterInterfacePO)this.getPoNode());
                dataCubeRefValidator = new TestDataCubeReferenceValidator(activeProject);
            }
            this.m_referencedCubePropDesc = new ContentAssistedTextPropertyDescriptor(new ReferenceTestDataController(this), P_ELEMENT_DISPLAY_REFDATA, dataCubeRefProposalProvider, dataCubeRefValidator, 2);
            this.m_referencedCubePropDesc.setCategory(P_TESTDATA_CAT);
        }
        this.addPropertyDescriptor((IPropertyDescriptor)this.m_referencedCubePropDesc);
        if (this.m_lockPropDesc == null) {
            PropertyDescriptor propDes = new PropertyDescriptor((Object)new LockInterfaceController(), P_ELEMENT_DISPLAY_PARAM_LOCKED);
            propDes.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
            this.m_lockPropDesc = propDes;
        }
        this.addPropertyDescriptor(this.m_lockPropDesc);
        this.addPropertyDescriptor(this.getOMCategorieDescriptor());
        this.initParameterPropDescriptors();
        this.initTrackedChangesPropDescriptor();
    }

    private IPropertyDescriptor getOMCategorieDescriptor() {
        if (this.m_oMCatPropDesc == null) {
            PropertyDescriptor cbpd = new PropertyDescriptor((Object)new OMCategorieController(), org.eclipse.jubula.client.ui.rcp.i18n.Messages.SpecTestCaseGUIPropertySourceOMCat);
            cbpd.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
            this.m_oMCatPropDesc = cbpd;
        }
        return this.m_oMCatPropDesc;
    }

    private void initParameterPropDescriptors() {
        ArrayList<PropertyDescriptor> paramPropDescList = new ArrayList<PropertyDescriptor>();
        List paramList = ((IParamNodePO)this.getPoNode()).getParameterList();
        IParamNameMapper activeParamNameMapper = this.getActiveParamNameMapper();
        for (IParamDescriptionPO paramDescr : paramList) {
            PropertyDescriptor propDes = TestDataControlFactory.createValuePropertyDescriptor(new ParameterValueController((AbstractNodePropertySource)this, paramDescr, activeParamNameMapper), this.getParameterNameDescr(paramDescr), new HashMap<String, String>(), false);
            propDes.setCategory(P_PARAMETER_CAT);
            propDes.setLabelProvider((ILabelProvider)new ParameterValueLabelProvider(WARNING_IMAGE));
            paramPropDescList.add(propDes);
        }
        this.addPropertyDescriptor(paramPropDescList);
    }

    protected IPropertyDescriptor getDataSourcePropertyDescr(final SpecTestCaseTestDataSourceController tdsc) {
        ComboBoxPropertyDescriptor cbpd = new ComboBoxPropertyDescriptor((Object)tdsc, P_ELEMENT_DISPLAY_DATASOURCE, tdsc.getUserChoosableDataSource());
        cbpd.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                int dataSource = (Integer)element;
                return I18n.getString((String)tdsc.getDataSourceArray()[dataSource]);
            }
        });
        cbpd.setCategory(P_TESTDATA_CAT);
        return cbpd;
    }

    public class ExternalDataController
    extends AbstractPropertySource.AbstractPropertyController
    implements IParameterPropertyController {
        public ExternalDataController(AbstractNodePropertySource s) {
            super(s);
        }

        public boolean setProperty(Object value) {
            if (SpecTestCaseGUIPropertySource.this.getPoNode() != null) {
                IParamNodePO node = (IParamNodePO)SpecTestCaseGUIPropertySource.this.getPoNode();
                node.clearTestData();
                if (value != null) {
                    node.setDataFile(String.valueOf(value));
                } else {
                    node.setDataFile(null);
                }
                this.getPropertySource().updateParameterInputType();
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
                if (StringUtils.isNotEmpty((String)node.getDataFile())) {
                    this.getPropertySource().setActiveParameterInputType(this.getInputType());
                }
            }
            return true;
        }

        public String getProperty() {
            IParamNodePO node;
            if (SpecTestCaseGUIPropertySource.this.getPoNode() != null && StringUtils.isNotEmpty((String)(node = (IParamNodePO)SpecTestCaseGUIPropertySource.this.getPoNode()).getDataFile())) {
                this.getPropertySource().updateParameterInputType();
                return node.getDataFile();
            }
            this.getPropertySource().setReadOnly(false);
            return "";
        }

        @Override
        public IParameterPropertyController.ParameterInputType getInputType() {
            return IParameterPropertyController.ParameterInputType.EXTERNAL;
        }

        @Override
        public boolean isPropertySet() {
            if (SpecTestCaseGUIPropertySource.this.getPoNode() != null) {
                IParamNodePO node = (IParamNodePO)SpecTestCaseGUIPropertySource.this.getPoNode();
                return StringUtils.isNotEmpty((String)node.getDataFile());
            }
            return false;
        }
    }

    public final class LockInterfaceController
    extends AbstractPropertySource.AbstractPropertyController {
        public Object getProperty() {
            ISpecTestCasePO specTc = (ISpecTestCasePO)SpecTestCaseGUIPropertySource.this.getPoNode();
            boolean isInterfaceLocked = specTc.isInterfaceLocked();
            return isInterfaceLocked ? org.eclipse.jubula.client.ui.rcp.i18n.Messages.UtilsYes : org.eclipse.jubula.client.ui.rcp.i18n.Messages.UtilsNo;
        }

        public boolean setProperty(Object value) {
            return false;
        }
    }

    protected class OMCategorieController
    extends AbstractPropertySource.AbstractPropertyController {
        protected OMCategorieController() {
        }

        public boolean setProperty(Object value) {
            return false;
        }

        public Object getProperty() {
            ISpecTestCasePO poNode = (ISpecTestCasePO)SpecTestCaseGUIPropertySource.this.getNode();
            List omCategoryAssoc = poNode.getOmCategoryAssoc();
            if (omCategoryAssoc != null) {
                return omCategoryAssoc.stream().map(IPersistentObject::getName).collect(Collectors.joining(","));
            }
            return "";
        }
    }

    public class ParameterValueController
    extends AbstractNodePropertySource.AbstractParamValueController
    implements IParameterPropertyController {
        public ParameterValueController(AbstractNodePropertySource s, IParamDescriptionPO paramDescr, IParamNameMapper paramNameMapper) {
            super(s, paramDescr, paramNameMapper);
        }

        @Override
        public IParameterPropertyController.ParameterInputType getInputType() {
            return IParameterPropertyController.ParameterInputType.LOCAL;
        }
    }

    public class ReferenceTestDataController
    extends AbstractPropertySource.AbstractPropertyController
    implements IParameterPropertyController {
        public ReferenceTestDataController(AbstractNodePropertySource s) {
            super(s);
        }

        public boolean setProperty(Object value) {
            if (SpecTestCaseGUIPropertySource.this.getPoNode() instanceof IParamNodePO) {
                IParamNodePO node = (IParamNodePO)SpecTestCaseGUIPropertySource.this.getPoNode();
                IParameterInterfacePO oldRefTestData = node.getReferencedDataCube();
                node.clearTestData();
                String valueString = (String)value;
                if (!StringUtils.isEmpty((String)valueString)) {
                    AbstractJBEditor activeEditor = Plugin.getDefault().getActiveJBEditor();
                    if (activeEditor == null) {
                        LOG.error(org.eclipse.jubula.client.ui.rcp.i18n.Messages.ActiveJubulaEditorReferenceNotNull);
                        return false;
                    }
                    IParameterInterfacePO dataCube = TestDataCubeBP.getTestDataCubeByName((String)valueString, (IProjectPO)GeneralStorage.getInstance().getProject());
                    if (dataCube == null) {
                        if (LOG.isInfoEnabled()) {
                            StringBuilder msg = new StringBuilder();
                            msg.append(org.eclipse.jubula.client.ui.rcp.i18n.Messages.CouldNotFindTestDataNamed).append(" ").append("'").append(valueString).append("'").append(" ").append(org.eclipse.jubula.client.ui.rcp.i18n.Messages.InCurrentProject);
                            LOG.info(msg.toString());
                        }
                        return false;
                    }
                    node.setReferencedDataCube((IParameterInterfacePO)activeEditor.getEditorHelper().getEditSupport().getSession().find(PoMaker.getTestDataCubeClass(), (Object)dataCube.getId()));
                    if (node instanceof IExecTestCasePO) {
                        ((IExecTestCasePO)node).setHasReferencedTD(false);
                    }
                } else {
                    node.setReferencedDataCube(null);
                }
                boolean wasModified = !ObjectUtils.equals((Object)oldRefTestData, (Object)node.getReferencedDataCube());
                this.getPropertySource().updateParameterInputType();
                if (wasModified) {
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
                }
                return wasModified;
            }
            return false;
        }

        public String getProperty() {
            IParamNodePO node;
            if (SpecTestCaseGUIPropertySource.this.getPoNode() != null && (node = (IParamNodePO)SpecTestCaseGUIPropertySource.this.getPoNode()).getReferencedDataCube() != null) {
                this.getPropertySource().updateParameterInputType();
                return node.getReferencedDataCube().getName();
            }
            return "";
        }

        @Override
        public IParameterPropertyController.ParameterInputType getInputType() {
            return IParameterPropertyController.ParameterInputType.REFERENCE;
        }

        @Override
        public boolean isPropertySet() {
            if (SpecTestCaseGUIPropertySource.this.getPoNode() != null) {
                IParamNodePO node = (IParamNodePO)SpecTestCaseGUIPropertySource.this.getPoNode();
                return node.getReferencedDataCube() != null;
            }
            return false;
        }
    }

    public class SpecTestCaseTestDataSourceController
    extends AbstractPropertySource.AbstractPropertyController
    implements IParameterPropertyController {
        protected static final String UNKOWN_DATA_SOURCE = "TestDataSource.unkown";
        protected static final String DATA_SOURCE_CTDS = "TestDataSource.central";
        protected static final String DATA_SOURCE_EXCEL = "TestDataSource.excel";
        protected static final String DATA_SOURCE_LOCAL = "TestDataSource.local";
        protected static final String DATA_SOURCE_NONE = "TestDataSource.none";
        private final List<String> m_dataSources;
        private final List<String> m_userChoosableValues;

        public SpecTestCaseTestDataSourceController(AbstractNodePropertySource s) {
            super(s);
            this.m_dataSources = new LinkedList<String>();
            this.m_userChoosableValues = new LinkedList<String>();
            this.getDataSource().add(DATA_SOURCE_LOCAL);
            this.getDataSource().add(DATA_SOURCE_EXCEL);
            this.getDataSource().add(DATA_SOURCE_CTDS);
            this.getDataSource().add(DATA_SOURCE_NONE);
            this.getDataSource().add(UNKOWN_DATA_SOURCE);
        }

        public boolean setProperty(Object value) {
            return false;
        }

        public Object getProperty() {
            if (SpecTestCaseGUIPropertySource.this.getPoNode() instanceof IParamNodePO) {
                IParamNodePO node = (IParamNodePO)SpecTestCaseGUIPropertySource.this.getPoNode();
                String dataSource = this.getDataSource(node);
                this.getPropertySource().setReadOnly(true);
                return this.getDataSource().indexOf(dataSource);
            }
            return this.getDataSource().indexOf(UNKOWN_DATA_SOURCE);
        }

        protected String getDataSource(IParamNodePO node) {
            if (!StringUtils.isBlank((String)node.getDataFile())) {
                return DATA_SOURCE_EXCEL;
            }
            if (node.getReferencedDataCube() != null) {
                return DATA_SOURCE_CTDS;
            }
            if (node.getParameterListSize() == 0) {
                return DATA_SOURCE_NONE;
            }
            if (node instanceof ISpecTestCasePO || node instanceof ICapPO) {
                return DATA_SOURCE_LOCAL;
            }
            return UNKOWN_DATA_SOURCE;
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }

        public String[] getDataSourceArray() {
            return this.m_dataSources.toArray(new String[this.m_dataSources.size()]);
        }

        public List<String> getDataSourceList() {
            return this.getDataSource();
        }

        public List<String> getDataSource() {
            return this.m_dataSources;
        }

        public String[] getUserChoosableDataSource() {
            if (this.getUserChoosableValues().isEmpty()) {
                this.getUserChoosableValues().add(I18n.getString((String)DATA_SOURCE_LOCAL));
            }
            return this.getUserChoosableValues().toArray(new String[this.getUserChoosableValues().size()]);
        }

        protected List<String> getUserChoosableValues() {
            return this.m_userChoosableValues;
        }

        @Override
        public IParameterPropertyController.ParameterInputType getInputType() {
            return IParameterPropertyController.ParameterInputType.LOCAL;
        }

        @Override
        public boolean isPropertySet() {
            return false;
        }
    }
}

