/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.core.utils.NativeSQLUtils;
import org.eclipse.jubula.client.ui.rcp.actions.TransactionWrapper;

public abstract class AbstractBrowserDndSupport {
    protected AbstractBrowserDndSupport() {
    }

    protected static boolean doMove(final List<INodePO> nodes, final IPersistentObject target) {
        if (nodes.isEmpty()) {
            return false;
        }
        final HashSet<Object> toLock = new HashSet<Object>();
        final HashSet<Object> toRefresh = new HashSet<Object>();
        GeneralStorage.getInstance().getProject();
        for (INodePO node : nodes) {
            toLock.add(node.getParentNode());
            toRefresh.add(node.getParentNode());
            toLock.add(node);
            toRefresh.add(node);
        }
        toLock.add(target);
        toRefresh.add(target);
        boolean succ = TransactionWrapper.executeOperation(new TransactionSupport.ITransaction(){

            public void run(EntityManager sess) {
                for (INodePO node : nodes) {
                    NativeSQLUtils.moveNode((EntityManager)sess, (INodePO)node, (IPersistentObject)target);
                }
            }

            public Collection<? extends IPersistentObject> getToRefresh() {
                return toRefresh;
            }

            public Collection<? extends IPersistentObject> getToLock() {
                return toLock;
            }

            public Collection<? extends IPersistentObject> getToMerge() {
                return null;
            }
        });
        if (!succ) {
            return false;
        }
        ArrayList<DataChangedEvent> eventList = new ArrayList<DataChangedEvent>();
        for (INodePO nodeToMove : nodes) {
            eventList.add(new DataChangedEvent(target, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.notInEditor));
            eventList.add(new DataChangedEvent((IPersistentObject)nodeToMove.getParentNode(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.notInEditor));
        }
        DataEventDispatcher.getInstance().fireDataChangedListener(eventList.toArray(new DataChangedEvent[0]));
        return true;
    }
}

