/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.util.Pair;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.zest.fx.ZestProperties;
import org.eclipse.gef.zest.fx.parts.AbstractLabelPart;

public class EdgeLabelPart
extends AbstractLabelPart {
    @Override
    public Point computeLabelPosition() {
        Point position = null;
        String value = (String)this.getContent().getValue();
        if ("element-label".equals(value)) {
            position = this.getMidPoint();
        } else if ("element-external-label".equals(value)) {
            position = this.getMidPoint();
        } else if ("edge-source-label".equals(value)) {
            position = this.getStartPoint();
        } else if ("edge-target-label".equals(value)) {
            position = this.getEndPoint();
        }
        return position;
    }

    protected Group doCreateVisual() {
        Text text = this.createText();
        Group g = new Group();
        g.getStyleClass().add((Object)"edge");
        g.getChildren().add((Object)text);
        return g;
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        HashMultimap contentAnchorages = HashMultimap.create();
        contentAnchorages.put(this.getContent().getKey(), (Object)((String)this.getContent().getValue()));
        return contentAnchorages;
    }

    protected void doRefreshVisual(Group visual) {
        Edge edge = (Edge)this.getContent().getKey();
        ReadOnlyMapProperty attrs = edge.attributesProperty();
        if ("element-label".equals(this.getContent().getValue())) {
            String label = ZestProperties.getLabel(edge);
            if (label != null) {
                this.getText().setText(label);
            }
            if (attrs.containsKey("element-label-css-style")) {
                String textCssStyle = ZestProperties.getLabelCssStyle(edge);
                ((Group)this.getVisual()).setStyle(textCssStyle);
            }
        } else if ("element-external-label".equals(this.getContent().getValue())) {
            String label = ZestProperties.getExternalLabel(edge);
            if (label != null) {
                this.getText().setText(label);
            }
            if (attrs.containsKey("element-external-label-css-style")) {
                String textCssStyle = ZestProperties.getExternalLabelCssStyle(edge);
                ((Group)this.getVisual()).setStyle(textCssStyle);
            }
        } else if ("edge-source-label".equals(this.getContent().getValue())) {
            String label = ZestProperties.getSourceLabel(edge);
            if (label != null) {
                this.getText().setText(label);
            }
            if (attrs.containsKey("edge-source-label-css-style")) {
                String textCssStyle = ZestProperties.getSourceLabelCssStyle(edge);
                ((Group)this.getVisual()).setStyle(textCssStyle);
            }
        } else if ("edge-target-label".equals(this.getContent().getValue())) {
            String label = ZestProperties.getTargetLabel(edge);
            if (label != null) {
                this.getText().setText(label);
            }
            if (attrs.containsKey("edge-target-label-css-style")) {
                String textCssStyle = ZestProperties.getTargetLabelCssStyle(edge);
                ((Group)this.getVisual()).setStyle(textCssStyle);
            }
        }
        if (this.getFirstAnchorage() == null) {
            return;
        }
        this.refreshPosition(this.getVisual(), this.getLabelPosition());
    }

    public Pair<Edge, String> getContent() {
        return super.getContent();
    }

    protected Point getEndPoint() {
        Connection connection = (Connection)this.getFirstAnchorage().getVisual();
        Point endPoint = connection.getEndPoint();
        Vector v = new Vector(endPoint, connection.getStartPoint());
        if (!v.isNull()) {
            v = v.getNormalized().getMultiplied(this.getText().getLayoutBounds().getHeight());
        }
        return NodeUtils.sceneToLocal((Node)((Group)this.getVisual()).getParent(), (Point)NodeUtils.localToScene((Node)connection, (Point)endPoint.getTranslated(v.x, v.y)));
    }

    protected IContentPart<? extends Connection> getFirstAnchorage() {
        return this.getAnchoragesUnmodifiable().isEmpty() ? null : (IContentPart)this.getAnchoragesUnmodifiable().keys().iterator().next();
    }

    protected Point getMidPoint() {
        Connection connection = (Connection)this.getFirstAnchorage().getVisual();
        Point midPoint = connection.getCenter();
        return NodeUtils.sceneToLocal((Node)((Group)this.getVisual()).getParent(), (Point)NodeUtils.localToScene((Node)connection, (Point)midPoint));
    }

    protected Point getStartPoint() {
        Connection connection = (Connection)this.getFirstAnchorage().getVisual();
        Point startPoint = connection.getStartPoint();
        Vector v = new Vector(startPoint, connection.getEndPoint());
        if (!v.isNull()) {
            v = v.getNormalized().getMultiplied(this.getText().getLayoutBounds().getHeight());
        }
        return NodeUtils.sceneToLocal((Node)((Group)this.getVisual()).getParent(), (Point)NodeUtils.localToScene((Node)connection, (Point)startPoint.getTranslated(v.x, v.y)));
    }
}

