/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.style.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.style.Style;
import org.eclipse.gef.dot.internal.language.style.StyleFactory;
import org.eclipse.gef.dot.internal.language.style.StyleItem;
import org.eclipse.gef.dot.internal.language.style.StylePackage;
import org.eclipse.gef.dot.internal.language.style.impl.StyleImpl;
import org.eclipse.gef.dot.internal.language.style.impl.StyleItemImpl;

public class StyleFactoryImpl
extends EFactoryImpl
implements StyleFactory {
    public static StyleFactory init() {
        try {
            StyleFactory theStyleFactory = (StyleFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/gef/dot/internal/language/DotStyle");
            if (theStyleFactory != null) {
                return theStyleFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new StyleFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createStyle();
            }
            case 1: {
                return this.createStyleItem();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createNodeStyleFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createEdgeStyleFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertNodeStyleToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertEdgeStyleToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Style createStyle() {
        StyleImpl style = new StyleImpl();
        return style;
    }

    @Override
    public StyleItem createStyleItem() {
        StyleItemImpl styleItem = new StyleItemImpl();
        return styleItem;
    }

    public NodeStyle createNodeStyleFromString(EDataType eDataType, String initialValue) {
        NodeStyle result = NodeStyle.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertNodeStyleToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public EdgeStyle createEdgeStyleFromString(EDataType eDataType, String initialValue) {
        EdgeStyle result = EdgeStyle.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertEdgeStyleToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public StylePackage getStylePackage() {
        return (StylePackage)this.getEPackage();
    }

    @Deprecated
    public static StylePackage getPackage() {
        return StylePackage.eINSTANCE;
    }
}

