/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.outline;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class DotHtmlLabelOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    private IXtextDocument xtextDocument;
    private int offset = 0;

    void setOffset(int offset) {
        this.offset = offset;
    }

    void setXtextDocument(IXtextDocument xtextDocument) {
        this.xtextDocument = xtextDocument;
    }

    public void _createChildren(DocumentRootNode outlineNode, HtmlLabel model) {
        for (HtmlContent htmlContent : model.getParts()) {
            if (htmlContent.getText() != null && !htmlContent.getText().trim().isEmpty()) {
                this.createNode((IOutlineNode)outlineNode, (EObject)htmlContent);
                continue;
            }
            if (htmlContent.getTag() == null) continue;
            this.createNode((IOutlineNode)outlineNode, (EObject)htmlContent.getTag());
        }
    }

    public void _createNode(IOutlineNode parent, HtmlContent htmlContent) {
        if (htmlContent.getText() != null && !htmlContent.getText().trim().isEmpty()) {
            super._createNode(parent, (EObject)htmlContent);
        } else if (htmlContent.getTag() != null) {
            super._createNode(parent, (EObject)htmlContent.getTag());
        }
    }

    protected EObjectNode createEObjectNode(IOutlineNode parentNode, EObject modelElement, Image image, Object text, boolean isLeaf) {
        EObjectNode eObjectNode = new EObjectNode(modelElement, parentNode, image, text, isLeaf){

            public IXtextDocument getDocument() {
                return DotHtmlLabelOutlineTreeProvider.this.xtextDocument != null ? DotHtmlLabelOutlineTreeProvider.this.xtextDocument : super.getDocument();
            }
        };
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)modelElement);
        if (parserNode != null) {
            ITextRegion parserNodeTextRegion = parserNode.getTextRegion();
            TextRegion newTextRegion = new TextRegion(parserNodeTextRegion.getOffset() + this.offset, parserNodeTextRegion.getLength());
            eObjectNode.setTextRegion((ITextRegion)newTextRegion);
        }
        ITextRegion significantTextRegion = this.locationInFileProvider.getSignificantTextRegion(modelElement);
        TextRegion shortTextRegion = new TextRegion(significantTextRegion.getOffset() + this.offset, significantTextRegion.getLength());
        eObjectNode.setShortTextRegion((ITextRegion)shortTextRegion);
        return eObjectNode;
    }
}

