/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.internal.core.util.WeakCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingResourceLoaderImpl
implements ResourceLoader {
    private ResourceLoader delegate;
    private WeakCache<String, URL> getResource = new WeakCache<String, URL>(){

        @Override
        protected URL createNew(String uri) {
            return CachingResourceLoaderImpl.this.delegate.getResource(uri);
        }
    };
    private WeakCache<String, Class<?>> loadClass = new WeakCache<String, Class<?>>(){

        @Override
        protected Class<?> createNew(String clazzName) {
            return CachingResourceLoaderImpl.this.delegate.loadClass(clazzName);
        }
    };

    public CachingResourceLoaderImpl(ResourceLoader delegate) {
        this.delegate = delegate;
    }

    @Override
    public URL getResource(String uri) {
        return this.getResource.get(uri);
    }

    @Override
    public final InputStream getResourceAsStream(String uri) {
        URL resource = this.getResource(uri);
        if (resource != null) {
            try {
                return resource.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String clazzName) {
        return this.loadClass.get(clazzName);
    }
}

