/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationsDelegatingList
implements List<Customization> {
    private final List<FacetSet> delegate;

    public CustomizationsDelegatingList(List<FacetSet> delegate) {
        this.delegate = delegate;
    }

    private List<Customization> createSubList() {
        ArrayList<Customization> customizations = new ArrayList<Customization>(this.delegate.size());
        for (FacetSet facetSet : this.delegate) {
            if (!(facetSet instanceof Customization)) continue;
            Customization customization = (Customization)facetSet;
            customizations.add(customization);
        }
        return customizations;
    }

    private static void throwOutOfBoundException(int index, int customIndex) {
        String message = String.format("Index: %d, Size: %d", index, customIndex);
        throw new IndexOutOfBoundsException(message);
    }

    @Override
    public int size() {
        return this.createSubList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.createSubList().isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return element instanceof Customization && this.delegate.contains(element);
    }

    @Override
    public Iterator<Customization> iterator() {
        List<Customization> customizations = this.createSubList();
        return customizations.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.createSubList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.createSubList().toArray(array);
    }

    @Override
    public boolean add(Customization customization) {
        return this.delegate.add((FacetSet)customization);
    }

    @Override
    public boolean remove(Object element) {
        return this.delegate.remove(element);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.createSubList().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends Customization> collection) {
        return this.delegate.addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Customization> collection) {
        boolean addAllDone = false;
        int customIndex = 0;
        int i = 0;
        while (i < this.delegate.size()) {
            FacetSet facetSet = this.delegate.get(i);
            if (facetSet instanceof Customization) {
                if (customIndex == index) {
                    addAllDone = true;
                    this.delegate.addAll(i, collection);
                    break;
                }
                ++customIndex;
            }
            ++i;
        }
        return addAllDone;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        for (FacetSet next : this.delegate) {
            if (!(next instanceof Customization) || collection.contains(next)) continue;
            this.delegate.remove(next);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        ArrayList<Customization> customToClear = new ArrayList<Customization>();
        for (FacetSet facetSet : this.delegate) {
            if (!(facetSet instanceof Customization)) continue;
            customToClear.add((Customization)facetSet);
        }
        this.delegate.removeAll(customToClear);
    }

    @Override
    public Customization get(int index) {
        Customization getValue = null;
        int customIndex = 0;
        for (FacetSet facetSet : this.delegate) {
            if (!(facetSet instanceof Customization)) continue;
            if (customIndex == index) {
                getValue = (Customization)facetSet;
                break;
            }
            ++customIndex;
        }
        if (getValue == null) {
            CustomizationsDelegatingList.throwOutOfBoundException(index, customIndex);
        }
        return getValue;
    }

    @Override
    public Customization set(int index, Customization element) {
        Customization oldValue = null;
        int customIndex = 0;
        int i = 0;
        while (i < this.delegate.size()) {
            FacetSet facetSet = this.delegate.get(i);
            if (facetSet instanceof Customization) {
                if (customIndex == index) {
                    oldValue = (Customization)facetSet;
                    this.delegate.set(i, (FacetSet)element);
                    break;
                }
                ++customIndex;
            }
            ++i;
        }
        if (oldValue == null) {
            CustomizationsDelegatingList.throwOutOfBoundException(index, customIndex);
        }
        return oldValue;
    }

    @Override
    public void add(int index, Customization element) {
        Customization movedFacet = null;
        int customIndex = 0;
        if (index == 0) {
            this.delegate.add(0, (FacetSet)element);
        } else {
            int i = 0;
            while (i < this.delegate.size()) {
                FacetSet facetSet = this.delegate.get(i);
                if (facetSet instanceof Customization) {
                    if (customIndex == index) {
                        movedFacet = (Customization)facetSet;
                        this.delegate.add(i, (FacetSet)element);
                        break;
                    }
                    ++customIndex;
                }
                ++i;
            }
            if (movedFacet == null) {
                CustomizationsDelegatingList.throwOutOfBoundException(index, customIndex);
            }
        }
    }

    @Override
    public Customization remove(int index) {
        Customization removedCustom = null;
        int customIndex = 0;
        int i = 0;
        while (i < this.delegate.size()) {
            FacetSet facetSet = this.delegate.get(i);
            if (facetSet instanceof Customization) {
                if (customIndex == index) {
                    removedCustom = (Customization)facetSet;
                    this.delegate.remove(i);
                    break;
                }
                ++customIndex;
            }
            ++i;
        }
        if (removedCustom == null) {
            CustomizationsDelegatingList.throwOutOfBoundException(index, customIndex);
        }
        return removedCustom;
    }

    @Override
    public int indexOf(Object element) {
        int indexOfElement = -1;
        int customIndex = 0;
        for (FacetSet facetSet : this.delegate) {
            if (!(facetSet instanceof Customization)) continue;
            if (facetSet.equals(element)) {
                indexOfElement = customIndex;
                break;
            }
            ++customIndex;
        }
        return indexOfElement;
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.createSubList().lastIndexOf(element);
    }

    @Override
    public ListIterator<Customization> listIterator() {
        return this.createSubList().listIterator();
    }

    @Override
    public ListIterator<Customization> listIterator(int index) {
        return this.createSubList().listIterator(index);
    }

    @Override
    public List<Customization> subList(int fromIndex, int toIndex) {
        ArrayList<Customization> subList = new ArrayList<Customization>();
        int customIndex = 0;
        for (FacetSet facetSet : this.delegate) {
            if (!(facetSet instanceof Customization)) continue;
            if (customIndex >= fromIndex && customIndex < toIndex) {
                subList.add((Customization)facetSet);
            } else if (customIndex >= toIndex) break;
            ++customIndex;
        }
        return subList;
    }
}

