/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.core.SourceIndexUtil;

public class IndexDocument {
    private final IDLTKLanguageToolkit toolkit;
    private final ISourceModule module;
    private final Index index;
    private IPath path = null;
    private final String containerRelativePath;

    public IndexDocument(IDLTKLanguageToolkit toolkit, ISourceModule module, IPath containerPath, Index index) {
        this.toolkit = toolkit;
        this.module = module;
        this.index = index;
        this.path = module.getPath();
        this.containerRelativePath = SourceIndexUtil.containerRelativePath(containerPath, module, this.path);
    }

    public ISourceModule getSourceModule() {
        return this.module;
    }

    public IDLTKLanguageToolkit getToolkit() {
        return this.toolkit;
    }

    public IPath getPath() {
        return this.path;
    }

    public String getContainerRelativePath() {
        return this.containerRelativePath;
    }

    public boolean isExternal() {
        return this.module instanceof IExternalSourceModule;
    }

    public void addIndexEntry(char[] category, char[] key) {
        this.index.addIndexEntry(category, key, this.containerRelativePath);
    }

    public Index getIndex() {
        return this.index;
    }
}

