/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.insert;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WorkbenchUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.insert.InsertGridViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.insert.InsertSelectViewer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class InsertTypeViewer
extends ContentViewer {
    Button valuesButton;
    Button queryButton;
    QueryStatement currentStatement;
    SQLDomainModel domainModel;
    PageBook insertPageBook;
    InsertSelectViewer insertSelectViewer;
    InsertGridViewer insertGridViewer;
    Combo insertQueryCombo;
    List stmtsList;
    Composite mainUIComponent;
    List prevValuesList = new ArrayList();
    QueryExpressionRoot prevQueryExpr;
    QueryInsertStatement insert = null;
    Object element;
    int fieldWidth = 10;
    int mleHeight = 10;
    boolean comboFilled = false;

    public InsertTypeViewer(SQLDomainModel sqlDomainModel) {
        this.domainModel = sqlDomainModel;
        this.insert = null;
        this.setContentProvider((IContentProvider)this.domainModel.createContentProvider());
    }

    public Control createControl(Composite parent) {
        this.mainUIComponent = ViewUtility.createComposite(parent, 1);
        Composite buttonGroup = ViewUtility.createComposite(this.mainUIComponent, 5);
        this.valuesButton = ViewUtility.createRadioButton(buttonGroup, Messages._UI_RADIO_VALUES);
        SelectListener valuesButtonSelectListener = new SelectListener();
        this.valuesButton.addSelectionListener((SelectionListener)valuesButtonSelectListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.valuesButton, "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        this.queryButton = ViewUtility.createRadioButton(buttonGroup, Messages._UI_RADIO_INSERT_FROM_SUBQUERY);
        SelectListener queryButtonSelectListener = new SelectListener();
        this.queryButton.addSelectionListener((SelectionListener)queryButtonSelectListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.queryButton, "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        this.valuesButton.setSelection(true);
        this.queryButton.setSelection(false);
        ViewUtility.createLabel(buttonGroup, Messages._UI_LABEL_QUERY_NAME);
        this.insertQueryCombo = ViewUtility.createComboBox(buttonGroup);
        this.insertQueryCombo.setText("");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.insertQueryCombo, "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0010");
        SelectListener queryComboListener = new SelectListener();
        this.insertQueryCombo.addSelectionListener((SelectionListener)queryComboListener);
        this.insertPageBook = new PageBook(this.mainUIComponent, 0);
        this.insertPageBook.setSize(150, 80);
        this.insertPageBook.setLayoutData((Object)ViewUtility.createFill());
        this.insertGridViewer = new InsertGridViewer(this.domainModel, (Composite)this.insertPageBook);
        this.insertGridViewer.getTable().setLinesVisible(true);
        this.insertGridViewer.getTable().setLayoutData((Object)ViewUtility.createFill());
        this.insertSelectViewer = new InsertSelectViewer(this.domainModel);
        this.insertSelectViewer.createControl((Composite)this.insertPageBook);
        this.insertPageBook.showPage(this.insertGridViewer.getControl());
        this.hookControl((Control)this.mainUIComponent);
        return this.mainUIComponent;
    }

    public Control getControl() {
        return this.mainUIComponent;
    }

    public void setInput(Object input) {
        this.insert = (QueryInsertStatement)input;
        this.initializeView();
        this.insertGridViewer.setInput(input);
        this.insertSelectViewer.setInput(input);
        super.setInput(input);
    }

    public Object getInput() {
        return this.insert;
    }

    public void inputChanged(Object newElement, Object oldElement) {
        this.initializeView();
        super.inputChanged(newElement, oldElement);
    }

    public void initializeView() {
        if (this.insert != null) {
            QueryExpressionRoot expr = this.insert.getSourceQuery();
            if (expr != null) {
                this.valuesButton.setSelection(false);
                this.queryButton.setSelection(true);
                if (!this.comboFilled) {
                    this.initializeCombo();
                    this.comboFilled = true;
                }
                this.insertPageBook.showPage(this.insertSelectViewer.getControl());
            } else {
                this.queryButton.setSelection(false);
                this.valuesButton.setSelection(true);
                this.insertPageBook.showPage(this.insertGridViewer.getControl());
                this.insertQueryCombo.setEnabled(false);
            }
            if (this.insert.getTargetTable() == null) {
                this.queryButton.setEnabled(false);
            } else {
                this.queryButton.setEnabled(true);
            }
        }
    }

    private void initializeCombo() {
        this.insertQueryCombo.removeAll();
        this.insertQueryCombo.setText("");
        IProject project = this.domainModel.getProject();
        this.stmtsList = WorkbenchUtility.getSelectStatementsFromProject(project, this.domainModel);
        for (IFile file : this.stmtsList) {
            String name = file.getName();
            name = name.substring(0, name.indexOf(".sql"));
            this.insertQueryCombo.add(name);
        }
        this.insertQueryCombo.add(SQLBuilderConstants.P_ADD_SELECT);
        if (VendorHelper.isFullSelectSupported(this.domainModel.getDatabase())) {
            this.insertQueryCombo.add(SQLBuilderConstants.P_ADD_FULLSELECT);
        }
        if (VendorHelper.isWithSupported(this.domainModel.getDatabase())) {
            this.insertQueryCombo.add(SQLBuilderConstants.P_ADD_WITH);
        }
    }

    public void refresh() {
        this.initializeView();
    }

    public final void setSelection(ISelection sel, boolean reveal) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void setEnabled(boolean enable) {
        this.insertSelectViewer.setEnabled(enable);
        this.insertGridViewer.setEnabled(enable);
        this.valuesButton.setEnabled(enable);
        if (this.insert != null) {
            if (this.insert.getTargetTable() == null) {
                this.queryButton.setEnabled(false);
            } else {
                this.queryButton.setEnabled(true);
            }
        }
        if (enable && this.queryButton.getSelection()) {
            this.insertQueryCombo.setEnabled(enable);
        }
    }

    class SelectListener
    implements SelectionListener {
        SelectListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            SQLQueryModelFactory queryFactory = SQLQueryModelFactory.eINSTANCE;
            if (e.widget == InsertTypeViewer.this.queryButton && InsertTypeViewer.this.queryButton.getSelection()) {
                InsertTypeViewer.this.insertPageBook.showPage(InsertTypeViewer.this.insertSelectViewer.getControl());
                QueryExpressionRoot expr = InsertTypeViewer.this.prevQueryExpr != null ? InsertTypeViewer.this.prevQueryExpr : queryFactory.createQueryExpressionRoot();
                InsertTypeViewer.this.insert.setSourceQuery(expr);
                EList values = InsertTypeViewer.this.insert.getSourceValuesRowList();
                if (values != null) {
                    InsertTypeViewer.this.prevValuesList.clear();
                    InsertTypeViewer.this.prevValuesList.addAll(values);
                    values.clear();
                }
                InsertTypeViewer.this.insertQueryCombo.setEnabled(true);
            } else if (e.widget == InsertTypeViewer.this.valuesButton && InsertTypeViewer.this.valuesButton.getSelection()) {
                QueryExpressionRoot expr;
                InsertTypeViewer.this.insertPageBook.showPage(InsertTypeViewer.this.insertGridViewer.getControl());
                InsertTypeViewer.this.prevQueryExpr = expr = InsertTypeViewer.this.insert.getSourceQuery();
                InsertTypeViewer.this.insert.setSourceQuery(null);
                EList values = InsertTypeViewer.this.insert.getSourceValuesRowList();
                if (values.isEmpty()) {
                    ValuesRow newValuesRow = queryFactory.createValuesRow();
                    values.add(newValuesRow);
                }
                InsertTypeViewer.this.insertQueryCombo.setEnabled(false);
            } else if (e.widget == InsertTypeViewer.this.insertQueryCombo && InsertTypeViewer.this.insert != null) {
                QueryExpressionRoot queryExpr = null;
                if (InsertTypeViewer.this.insertQueryCombo.getText().equals(SQLBuilderConstants.P_ADD_SELECT) || InsertTypeViewer.this.insertQueryCombo.getText().equals(SQLBuilderConstants.P_ADD_FULLSELECT) || InsertTypeViewer.this.insertQueryCombo.getText().equals(SQLBuilderConstants.P_ADD_WITH)) {
                    QuerySelectStatement queryStmt = null;
                    if (InsertTypeViewer.this.insertQueryCombo.getText().equals(SQLBuilderConstants.P_ADD_SELECT)) {
                        queryStmt = StatementHelper.createQuerySelectStatement((String)"");
                        StatementHelper.createQueryExpressionRoot((QuerySelectStatement)queryStmt);
                        StatementHelper.createQuerySelect((QuerySelectStatement)queryStmt);
                    } else {
                        queryStmt = InsertTypeViewer.this.insertQueryCombo.getText().equals(SQLBuilderConstants.P_ADD_FULLSELECT) ? StatementHelper.createQueryCombinedStatement((String)"") : StatementHelper.createWithStatement((String)"");
                    }
                    if (queryStmt != null) {
                        queryExpr = queryStmt.getQueryExpr();
                    }
                } else {
                    String selection;
                    QueryStatement stmt;
                    int index = InsertTypeViewer.this.insertQueryCombo.getSelectionIndex();
                    if (index >= 0 && (stmt = this.getQueryStatementforName(selection = InsertTypeViewer.this.insertQueryCombo.getItem(index))) instanceof QuerySelectStatement) {
                        queryExpr = SelectHelper.getQueryExpressionBody((QuerySelectStatement)stmt).getQueryExpression();
                    }
                }
                if (queryExpr != null) {
                    InsertTypeViewer.this.insert.setSourceQuery(queryExpr);
                }
            }
        }

        QueryStatement getQueryStatementforName(String name) {
            QueryStatement stmt = null;
            Iterator stmtsItr = InsertTypeViewer.this.stmtsList.iterator();
            if (stmtsItr != null) {
                IFile file = null;
                while (stmtsItr.hasNext()) {
                    file = (IFile)stmtsItr.next();
                    String fileName = file.getName();
                    if (name.equals(fileName = fileName.substring(0, fileName.indexOf(".sql")))) break;
                }
                if (file != null) {
                    String fileContent = WorkbenchUtility.readFileContentsToString(file, true).trim();
                    try {
                        stmt = InsertTypeViewer.this.domainModel.parse(fileContent, true);
                    }
                    catch (SQLParserInternalException sQLParserInternalException) {
                    }
                    catch (SQLParserException sQLParserException) {}
                }
            }
            return stmt;
        }
    }
}

