/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableFloatStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableFloatArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableFloatEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableFloatSingletonStack;

public enum ImmutableFloatStackFactoryImpl implements ImmutableFloatStackFactory
{
    INSTANCE;


    @Override
    public ImmutableFloatStack empty() {
        return ImmutableFloatEmptyStack.INSTANCE;
    }

    @Override
    public ImmutableFloatStack of() {
        return this.empty();
    }

    @Override
    public ImmutableFloatStack with() {
        return this.empty();
    }

    @Override
    public ImmutableFloatStack of(float one) {
        return this.with(one);
    }

    @Override
    public ImmutableFloatStack with(float one) {
        return new ImmutableFloatSingletonStack(one);
    }

    @Override
    public ImmutableFloatStack of(float ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableFloatStack with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatArrayStack.newStackWith(items);
    }

    @Override
    public ImmutableFloatStack ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableFloatStack withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatStack) {
            return (ImmutableFloatStack)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableFloatStack ofAllReversed(FloatIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public ImmutableFloatStack withAllReversed(FloatIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableFloatArrayStack.newStackFromTopToBottom(items);
    }
}

