/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ColumnBandAdapter;
import org.eclipse.birt.report.model.api.ColumnBandCopyAction;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.TableColumnBandAdapter;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

class ColumnBandPasteAction
extends ColumnBandCopyAction {
    public ColumnBandPasteAction(ColumnBandAdapter adapter) {
        super(adapter);
    }

    protected boolean canPaste(int columnIndex, boolean inForce, ColumnBandData data) {
        if (this.adapter.hasParent()) {
            return false;
        }
        List cells = data.getCells();
        List originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(columnIndex));
        if (!this.isRectangleArea(originalCells, 1)) {
            return false;
        }
        boolean isSameLayout = false;
        try {
            isSameLayout = this.isSameLayout(cells, originalCells);
        }
        catch (SemanticException semanticException) {
            return false;
        }
        return inForce || isSameLayout;
    }

    protected List pasteColumnBand(int columnIndex, boolean inForce, ColumnBandData data) throws SemanticException {
        boolean canDone = this.canPaste(columnIndex, inForce, data);
        if (inForce && !canDone) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_PASTE_FORBIDDEN");
        }
        if (!inForce && !canDone) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), "Error.SemanticError.COLUMN_PASTE_DIFFERENT_LAYOUT");
        }
        TableColumn column = data.getColumn();
        List cells = data.getCells();
        List originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(columnIndex));
        ActivityStack as = this.adapter.getModule().getActivityStack();
        try {
            if (this.adapter instanceof TableColumnBandAdapter) {
                as.startSilentTrans(CommandLabelFactory.getCommandLabel("Message.PasteColumnBand"));
            } else {
                as.startTrans(CommandLabelFactory.getCommandLabel("Message.PasteColumnBand"));
            }
            this.pasteColumn(column, columnIndex, false);
            this.pasteCells(cells, originalCells, columnIndex, false);
        }
        catch (SemanticException e) {
            as.rollback();
            throw e;
        }
        as.commit();
        return this.doPostPasteCheck(column, cells);
    }
}

