/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.model.api.olap;

import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IOdaOlapElementModel;

/**
 * Represents a cube.
 * 
 * @see org.eclipse.birt.report.model.elements.olap.Cube
 */

public class OdaCubeHandle extends CubeHandle implements IOdaOlapElementModel
{

	/**
	 * Constructs a handle for the given design and design element. The
	 * application generally does not create handles directly. Instead, it uses
	 * one of the navigation methods available on other element handles.
	 * 
	 * @param module
	 *            the module
	 * @param element
	 *            the model representation of the element
	 */

	public OdaCubeHandle( Module module, DesignElement element )
	{
		super( module, element );
	}

	/**
	 * Returns the ODA defined cube name.
	 * 
	 * @return the ODA defined cube name
	 */

	public String getNativeName( )
	{
		return getStringProperty( NATIVE_NAME_PROP );
	}

	/**
	 * Sets the ODA defined cube name.
	 * 
	 * @param nativeName
	 *            the ODA defined cube name
	 *            
	 * @throws SemanticException  
	 */
	
	public void setNativeName( String nativeName ) throws SemanticException
	{
		setProperty( NATIVE_NAME_PROP, nativeName );
	}
}
